package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process;

import org.apache.log4j.Logger;
import junit.framework.TestCase;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.*;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextRemovalRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextRemovalResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.HandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.DTWitness;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFContextRemovalResult;

/**
 * 
 */
public class UTContextRemovalProcess extends TestCase {

   private static final Logger logger = Logger.getLogger(UTContextRemovalProcess.class);

   protected void setUp() throws Exception {
   }

   protected void tearDown() throws Exception {
   }

   public void testContextRemoval() {
      // createContext
      ContextCreationProcess ctxCreateProc1 = null;
      {
         ctxCreateProc1 = DTProcess.getSucceedingContextCreationProcess4Client();
         ctxCreateProc1.perform();
         IFContextCreationResponse ctxCreateResp = ctxCreateProc1.getContextCreationResponse();
         assertNotNull(ctxCreateResp);
         IFCoordinationContext coordCtx = ctxCreateProc1.getHeaderResponse();
         assertNotNull(coordCtx);
      }
      // remove that context
      {
         ContextRemovalProcess ctxRemoveProc1 = DTProcess.getSucceedingContextRemovalProcess(ctxCreateProc1);
         ctxRemoveProc1.perform();
         IFContextRemovalResponse ctxRemoveResp = ctxRemoveProc1.getContextRemovalResponse();
         assertTrue(ctxRemoveResp.isSuccess());
         assertFalse(ctxRemoveResp.isFailure());
         assertFalse(ctxRemoveResp.isUnknown());
      }
      {
         ContextRemovalProcess ctxRemoveProc2 = DTProcess.getSucceedingContextRemovalProcess(ctxCreateProc1);
         ctxRemoveProc2.perform();
         IFContextRemovalResponse ctxRemoveResp2 = ctxRemoveProc2.getContextRemovalResponse();
         assertFalse(ctxRemoveResp2.isSuccess());
         assertFalse(ctxRemoveResp2.isFailure());
         assertFalse(ctxRemoveResp2.isUnknown());
         assertTrue(ctxRemoveResp2.getResultCode() == IFContextRemovalResponse.CONTEXT_NOT_MANAGED);
      }
   }

   public void testContextRemovalOnlyByRightEntity() {
      ContextCreationProcess ctxCreateProc1 = null;
      {
         ctxCreateProc1 = DTProcess.getSucceedingContextCreationProcess4Client();
         ctxCreateProc1.perform();
         IFContextCreationResponse ctxCreateResp = ctxCreateProc1.getContextCreationResponse();
         assertNotNull(ctxCreateResp);
         IFCoordinationContext coordCtx = ctxCreateProc1.getHeaderResponse();
         assertNotNull(coordCtx);
      }
      // try remove that context with wrong entity
      {
         IFContextRemovalRequest ctxRemovalRequest = DTWitness.getContextRemovalRequestOne(ctxCreateProc1.getContextCreationResponse());
         //IFHandlingInfo handlingInfo = DTWitness.getHandlingInfoOne(ctxCreateProc.getContextCreationRequest(), ctxCreateProc.getHeaderResponse());
         HandlingInfo handlingInfo = new HandlingInfo();
         CountingContext countingContext = new CountingContext();
         countingContext.setCoordinationContext(ctxCreateProc1.getHeaderResponse());
         handlingInfo.setCountingContext(countingContext);
         handlingInfo.getSignatureHandlingInfoBody().setActingEntity(DTWitness.getTicketBooking());
         handlingInfo.getSignatureHandlingInfoBody().setResultCode(IFSignatureHandlingInfo.SUCCESS);
         ContextRemovalProcess ctxRemoveProc1 = new ContextRemovalProcess(handlingInfo, ctxRemovalRequest);
         ctxRemoveProc1.perform();
         IFContextRemovalResponse ctxRemoveResp = ctxRemoveProc1.getContextRemovalResponse();
         assertFalse(ctxRemoveResp.isSuccess());
         assertFalse(ctxRemoveResp.isFailure());
         assertFalse(ctxRemoveResp.isUnknown());
         assertTrue(ctxRemoveResp.getResultCode() == IFContextRemovalResponse.WRONG_ENTITY);
      }
      // try remove that context with right entity
      {
         ContextRemovalProcess ctxRemoveProc1 = DTProcess.getSucceedingContextRemovalProcess(ctxCreateProc1);
         ctxRemoveProc1.perform();
         IFContextRemovalResponse ctxRemoveResp = ctxRemoveProc1.getContextRemovalResponse();
         assertTrue(ctxRemoveResp.isSuccess());
         assertFalse(ctxRemoveResp.isFailure());
         assertFalse(ctxRemoveResp.isUnknown());
      }
   }
}
