package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextRemovalRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.CountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextRemovalRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.HandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.DTWitness;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementRequest;

/**
 * 
 */
public class DTProcess {

   private static final Logger logger = Logger.getLogger(DTProcess.class);

   public static ContextCreationProcess getSucceedingContextCreationProcess4Client(){
      IFContextCreationRequest ctxCreateReq = DTWitness.getContextCreationRequestOne();
      IFHandlingInfo handlingInfo = DTWitness.getHandlingInfoOne(ctxCreateReq);
      handlingInfo.getSignatureHandlingInfoBody().setActingEntity(DTWitness.getClient1());
      handlingInfo.getSignatureHandlingInfoBody().setResultCode(IFSignatureHandlingInfo.SUCCESS);
      ContextCreationProcess ctxCreateProc1 = new ContextCreationProcess(handlingInfo, ctxCreateReq);
      return ctxCreateProc1;
   }

   public static ContextCreationProcess getSucceedingContextCreationProcess4Client(long lifeTime, long reqTimeout, long respTimeout){
      IFContextCreationRequest ctxCreateReq = DTWitness.getContextCreationRequestOne(lifeTime, reqTimeout, respTimeout);
      IFHandlingInfo handlingInfo = DTWitness.getHandlingInfoOne(ctxCreateReq);
      handlingInfo.getSignatureHandlingInfoBody().setActingEntity(DTWitness.getClient1());
      handlingInfo.getSignatureHandlingInfoBody().setResultCode(IFSignatureHandlingInfo.SUCCESS);
      ContextCreationProcess ctxCreateProc1 = new ContextCreationProcess(handlingInfo, ctxCreateReq);
      return ctxCreateProc1;
   }

   public static ContextRemovalProcess getSucceedingContextRemovalProcess(ContextCreationProcess ctxCreateProc){
      IFContextRemovalRequest ctxRemovalRequest = DTWitness.getContextRemovalRequestOne(ctxCreateProc.getContextCreationResponse());
      //IFHandlingInfo handlingInfo = DTWitness.getHandlingInfoOne(ctxCreateProc.getContextCreationRequest(), ctxCreateProc.getHeaderResponse());
      HandlingInfo handlingInfo = new HandlingInfo();
      CountingContext countingContext = new CountingContext();
      countingContext.setCoordinationContext(ctxCreateProc.getHeaderResponse());
      handlingInfo.setCountingContext(countingContext);
      handlingInfo.getSignatureHandlingInfoBody().setActingEntity(ctxCreateProc.getRequestHandlingInfo().getSignatureHandlingInfoBody().getActingEntity());
      handlingInfo.getSignatureHandlingInfoBody().setResultCode(IFSignatureHandlingInfo.SUCCESS);
      ContextRemovalProcess ctxRemoveProc1 = new ContextRemovalProcess(handlingInfo, ctxRemovalRequest);
      return ctxRemoveProc1;
   }

   public static DigesterProcess getSucceedingDigesterProcess(ContextCreationProcess ctxCreateProc){
      DigesterProcess result = null;
      IFDigestAgreementRequest digAgreeReq = DTWitness.getDigestAgreementRequest(ctxCreateProc.getHeaderResponse());
      HandlingInfo handlingInfo = new HandlingInfo();
      CountingContext countingContext = new CountingContext();
      countingContext.setCoordinationContext(ctxCreateProc.getHeaderResponse());
      handlingInfo.setCountingContext(countingContext);
      handlingInfo.getSignatureHandlingInfoBody().setActingEntity(ctxCreateProc.getRequestHandlingInfo().getSignatureHandlingInfoBody().getActingEntity());
      handlingInfo.getSignatureHandlingInfoBody().setResultCode(IFSignatureHandlingInfo.SUCCESS);
      result = new DigesterProcess(handlingInfo, digAgreeReq);
      return result;
   }

}
