package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.dependency;

import org.apache.log4j.Logger;
import junit.framework.TestCase;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency.IFSOAPDependency;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency.SOAPDependency;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency.IFSOAPDependencyStatement;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency.SOAPDependencyStatement;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.DigestAgreementConfirmationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFDigestAgreementConfirmationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFDigestAgreementConfirmationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.DigestAgreementConfirmationResult;

/**
 * 
 */
public class UTDependencyManager extends TestCase{

   private static final Logger logger = Logger.getLogger(UTDependencyManager.class);

   private DependencyManager manager = null;
   private SOAPDependency soapDep1 = null; // without dependency statements
   private SOAPDependency soapDep2 = null; // with one dependency statement (ref#1)
   private SOAPDependency soapDep3 = null;

   protected void setUp() throws Exception {
      manager = new DependencyManager();
      soapDep1 = new SOAPDependency();
      soapDep2 = new SOAPDependency();
      soapDep2.setDependencyStatements(new IFSOAPDependencyStatement[]{new SOAPDependencyStatement("ref#1")});
      soapDep3 = new SOAPDependency();
      soapDep3.setDependencyStatements(new IFSOAPDependencyStatement[]{new SOAPDependencyStatement("ref#1"), new SOAPDependencyStatement("ref#2")});
   }

   public void testBase(){
      assertTrue(manager.checkDependency(soapDep1));
      assertFalse(manager.checkDependency(soapDep2));
      assertFalse(manager.checkDependency(soapDep3));
      //soapDependency.setDependencyStatements();
      //assertTrue(false);
   }

   public void testAdding(){
      DigestAgreementConfirmationResult confResult = new DigestAgreementConfirmationResult();
      confResult.setResultCode(IFDigestAgreementConfirmationResult.SUCCESS);
      confResult.setResultMessage("successfull matched");
      confResult.setReference("ref#1");
      manager.addConfirmedDependency(soapDep1, confResult);
      assertTrue(manager.checkDependency(soapDep1));
      assertTrue(manager.checkDependency(soapDep2));
      assertFalse(manager.checkDependency(soapDep3));
      confResult = new DigestAgreementConfirmationResult();
      confResult.setResultCode(IFDigestAgreementConfirmationResult.SUCCESS);
      confResult.setResultMessage("successfull matched");
      confResult.setReference("ref#2");
      manager.addConfirmedDependency(soapDep1, confResult);
      assertTrue(manager.checkDependency(soapDep1));
      assertTrue(manager.checkDependency(soapDep2));
      assertTrue(manager.checkDependency(soapDep3));
   }

   public void testIsEqual(){
      SOAPDependency depOne = new SOAPDependency();
      SOAPDependency depTwo = new SOAPDependency();
      assertTrue(manager.isEqual(depOne, depTwo));
      assertTrue(manager.isEqual(depTwo, depOne));
      assertTrue(manager.isEqual(null, null));
      assertFalse(manager.isEqual(null, depOne));
      assertFalse(manager.isEqual(depOne, null));
      depOne.addDependencyStatement(new SOAPDependencyStatement("dep#1"));
      assertFalse(manager.isEqual(depOne, depTwo));
   }
}
