package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context;

import org.apache.log4j.Logger;
import junit.framework.TestCase;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCoordinationContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.CoordinationContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.ContextCreationRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.SignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.BodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.AccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.entity.EntityManagerFactory;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.DigestAgreementRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.DTWitness;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.ex.UnknownEntityException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.BodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.ex.UnknownEntityException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFDigestAgreementConfirmationResult;

/**
 * 
 */
public class UTContextManager extends TestCase {

   private static final Logger logger = Logger.getLogger(UTContextManager.class);


   protected void setUp() throws Exception {
   }

   protected void tearDown() throws Exception {
   }

   public void testContextLocator() {
      IFWitnessContextManager witnessContextManager = DTWitness.getContextManager();
      IFContextCreationRequest ctxCreatReq = DTWitness.getContextCreationRequestOne();
      IFCoordinationContext coordCtx = DTWitness.getCoordinationContextOne(ctxCreatReq);
      IFSignatureHandlingInfo cryptHandlingInfo = DTWitness.getCryptographicHandlingInfoOne();
      IFWitnessContextInfo ctxInfo = null;
      try {
         ctxInfo = witnessContextManager.registerContext(coordCtx, ctxCreatReq, cryptHandlingInfo);
      } catch (UnknownEntityException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
      assertEquals(ctxInfo, witnessContextManager.getContext(coordCtx));
   }

   public void testDigestAgreement() {
      IFWitnessContextManager witnessContextManager = DTWitness.getContextManager();
      IFContextCreationRequest ctxCreatReq = DTWitness.getContextCreationRequestOne();
      IFCoordinationContext coordCtx = DTWitness.getCoordinationContextOne(ctxCreatReq);
      IFSignatureHandlingInfo cryptHandlingInfo = DTWitness.getCryptographicHandlingInfoOne();
      IFDigestAgreementRequest digAgreeReq1 = DTWitness.getDigestAgreementRequestOne();
      IFDigestAgreementRequest digAgreeReq2 = DTWitness.getDigestAgreementRequestOne();

      try {
         IFWitnessContextInfo ctxInfo = witnessContextManager.registerContext(coordCtx, ctxCreatReq, cryptHandlingInfo);
      } catch (UnknownEntityException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
      witnessContextManager.registerDigestAgreementRequest(digAgreeReq1, DTWitness.getClient1(), new BodyEvidence(null));
      IFDigestAgreementConfirmationResult confResult = witnessContextManager.getConfirmationState(digAgreeReq1);
      assertFalse(confResult.isSuccess());
      assertFalse(confResult.isFailure());
      assertTrue(confResult.isUnknown());
//      assertFalse(confResult.isFailureInProcess());
      witnessContextManager.registerDigestAgreementRequest(digAgreeReq2, DTWitness.getTicketReservation(), new BodyEvidence(null));
      confResult = witnessContextManager.getConfirmationState(digAgreeReq1);
      assertTrue(confResult.isSuccess());
      assertFalse(confResult.isFailure());
      assertFalse(confResult.isUnknown());
//      assertFalse(confResult.isFailureInProcess());
      confResult = witnessContextManager.getConfirmationState(digAgreeReq1);
      assertTrue(confResult.isSuccess());
      assertFalse(confResult.isFailure());
      assertFalse(confResult.isUnknown());
//      assertFalse(confResult.isFailureInProcess());
      confResult = witnessContextManager.getConfirmationState(digAgreeReq2);
      assertTrue(confResult.isSuccess());
      assertFalse(confResult.isFailure());
      assertFalse(confResult.isUnknown());
//      assertFalse(confResult.isFailureInProcess());
      // now the process is beeing deleted because both parties have requested the result!
      confResult = witnessContextManager.getConfirmationState(digAgreeReq1);
      assertFalse(confResult.isSuccess());
      assertTrue(confResult.isFailure());
      assertFalse(confResult.isUnknown());
//      assertTrue(confResult.isFailureInProcess());
      assertEquals(confResult.getResultCode(), IFDigestAgreementConfirmationResult.NO_PROCESS);
   }
}

