package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account;

import org.apache.log4j.Logger;
import junit.framework.TestCase;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.Amount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.AmountTool;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAmount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFCurrency;

/**
 * 
 */
public class UTAmountTools extends TestCase{

   private static final Logger logger = Logger.getLogger(UTAmountTools.class);

   public void testIsEqualAmount(){
      Amount amountOne = new Amount(100, IFCurrency.CURRENCY_COUNTER_INST);
      Amount amountTwo = new Amount(100, IFCurrency.CURRENCY_COUNTER_INST);
      assertTrue(AmountTool.isEqual(amountOne, amountTwo));
      assertTrue(AmountTool.isEqual(amountTwo, amountOne));
      assertFalse(AmountTool.isEqual(amountOne, null));
      assertFalse(AmountTool.isEqual(null, amountTwo));
      assertTrue(AmountTool.isEqual((IFAmount)null, null));
      amountTwo = new Amount(100, IFCurrency.CURRENCY_EURO_INST);
      assertFalse(AmountTool.isEqual(amountOne, amountTwo));
      assertFalse(AmountTool.isEqual(amountTwo, amountOne));
      amountTwo = new Amount(101, IFCurrency.CURRENCY_COUNTER_INST);
      assertFalse(AmountTool.isEqual(amountOne, amountTwo));
      assertFalse(AmountTool.isEqual(amountTwo, amountOne));
      amountTwo = new Amount(101, IFCurrency.CURRENCY_EURO_INST);
      assertFalse(AmountTool.isEqual(amountOne, amountTwo));
      assertFalse(AmountTool.isEqual(amountTwo, amountOne));
   }

   public void testIsEqualCurrency(){
      IFCurrency currOne = IFCurrency.CURRENCY_COUNTER_INST;
      IFCurrency currTwo = IFCurrency.CURRENCY_COUNTER_INST;
      assertTrue(AmountTool.isEqual(currOne, currTwo));
      assertTrue(AmountTool.isEqual(currTwo, currOne));
      assertTrue(AmountTool.isEqual((IFCurrency)null, null));
      assertFalse(AmountTool.isEqual(currOne, null));
      assertFalse(AmountTool.isEqual(null, currTwo));
      currTwo = IFCurrency.CURRENCY_EURO_INST;
      assertFalse(AmountTool.isEqual(currOne, currTwo));
      assertFalse(AmountTool.isEqual(currTwo, currOne));
   }

}
