package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account;

import junit.framework.TestCase;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.Amount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFCurrency;

/**
 * Created by IntelliJ IDEA.
 * User: mr22
 * Date: 12.04.2005
 * Time: 18:04:17
 * To change this template use File | Settings | File Templates.
 */
public class UTAmount extends TestCase{

   protected void setUp() throws Exception {
   }

   protected void tearDown() throws Exception {
   }

   public void testSetGet(){
      float am = 100;
      IFCurrency usedCurrency = IFCurrency.CURRENCY_COUNTER_INST;
      Amount amount = new Amount(am, usedCurrency);
      assertEquals(amount.getAmount(), am, 0);
      assertEquals(amount.getCurrency(), usedCurrency);
   }

   public void testIncrease(){
      Amount amount = new Amount(100, IFCurrency.CURRENCY_COUNTER_INST);
      Amount toIncrease = new Amount(50, IFCurrency.CURRENCY_COUNTER_INST);
      amount.increase(toIncrease);
      assertEquals(amount.getAmount(), 150, 0);
      assertEquals(amount.getCurrency(), IFCurrency.CURRENCY_COUNTER_INST);
      assertEquals(toIncrease.getAmount(), 50, 0);
      assertEquals(toIncrease.getCurrency(), IFCurrency.CURRENCY_COUNTER_INST);
      toIncrease = new Amount(17.35f, IFCurrency.CURRENCY_COUNTER_INST);
      amount.increase(toIncrease);
      assertEquals(amount.getAmount(), 167.35, 0.001);
      assertEquals(amount.getCurrency(), IFCurrency.CURRENCY_COUNTER_INST);
   }

   public void testDecrease(){
      Amount amount = new Amount(100, IFCurrency.CURRENCY_COUNTER_INST);
      Amount toDecrease = new Amount(50, IFCurrency.CURRENCY_COUNTER_INST);
      amount.decrease(toDecrease);
      assertEquals(amount.getAmount(), 50, 0);
      assertEquals(amount.getCurrency(), IFCurrency.CURRENCY_COUNTER_INST);
      assertEquals(toDecrease.getAmount(), 50, 0);
      assertEquals(toDecrease.getCurrency(), IFCurrency.CURRENCY_COUNTER_INST);
      toDecrease = new Amount(17.35f, IFCurrency.CURRENCY_COUNTER_INST);
      amount.decrease(toDecrease);
      assertEquals(32.65, amount.getAmount(), 0.001);
      assertEquals(amount.getCurrency(), IFCurrency.CURRENCY_COUNTER_INST);
   }

   public void testIsNegative(){
      Amount amount = new Amount(100, IFCurrency.CURRENCY_COUNTER_INST);
      assertFalse(amount.isNegative());
      amount = new Amount(-1, IFCurrency.CURRENCY_COUNTER_INST);
      assertTrue(amount.isNegative());
   }

   public void testIsLargerAs(){
      Amount first = new Amount(100, IFCurrency.CURRENCY_COUNTER_INST);
      Amount second = new Amount(100, IFCurrency.CURRENCY_COUNTER_INST);
      assertFalse(first.isLargerAs(first));
      assertFalse(second.isLargerAs(second));
      assertFalse(first.isLargerAs(second));
      assertFalse(second.isLargerAs(first));
      first = new Amount(80, IFCurrency.CURRENCY_COUNTER_INST);
      assertFalse(first.isLargerAs(second));
      assertTrue(second.isLargerAs(first));
      first = new Amount(180, IFCurrency.CURRENCY_COUNTER_INST);
      assertTrue(first.isLargerAs(second));
      assertFalse(second.isLargerAs(first));
      first = new Amount(-180, IFCurrency.CURRENCY_COUNTER_INST);
      assertFalse(first.isLargerAs(second));
      assertTrue(second.isLargerAs(first));
      second = new Amount(-100, IFCurrency.CURRENCY_COUNTER_INST);
      assertFalse(first.isLargerAs(second));
      assertTrue(second.isLargerAs(first));
   }

}
