package de.tu_dresden.diplom.richter_mirko_mat2628335.soap;

import org.apache.log4j.Logger;
import org.apache.axis.client.Service;
import org.apache.axis.client.Call;
import junit.framework.TestCase;

import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import java.net.URL;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.Amount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFCurrency;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.AccountInfoItem;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.*;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfoItem;


/**
 * 
 */
public class UTInfoService extends TestCase {

   private static final Logger logger = Logger.getLogger(UTInfoService.class);

   public void testBaseInfoFunctionality() {
      final String fn = "[testBaseInfoFunctionality] ";
      AccountInfo info = new AccountInfo();
      AccountInfoItem[] req = new AccountInfoItem[2];
      final float defAmount = 77;
      final float oneAmount = 77;
      {
         AccountInfoItem def = new AccountInfoItem("default", new Amount(defAmount, IFCurrency.CURRENCY_COUNTER_INST));
         def.setOwnerIdentityID(1);
         req[0] = def;
      }
      {
         AccountInfoItem one = new AccountInfoItem("one", new Amount(oneAmount, IFCurrency.CURRENCY_COUNTER_INST));
         one.setOwnerIdentityID(1);
         req[1] = one;
      }
      info.setAccountInfoItems(req);
      HLPManagementPeer.setAccounts(info);
      IFAccountInfo accInfo = HLPInfoPeer.getAccountInfo();
      IFAccountInfoItem[] items = accInfo.getAccountInfoItems();
      for (int i = 0; i < items.length; i++) {
         IFAccountInfoItem item = items[i];
         if (item != null) {
            if (item.getAccountID().equals("default")) {
               assertEquals(defAmount, item.getAmount().getAmount(), 0);
            }else if(item.getAccountID().equals("one")){
               assertEquals(oneAmount, item.getAmount().getAmount(), 0);
            }
         }else{
            logger.warn(fn + "got NULL-item... suspicious behavior ;)");
         }
      }
   }

}
