package de.tu_dresden.diplom.richter_mirko_mat2628335.soap;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.management.IFManagementOperationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;
import de.tu_dresden.diplom.richter_mirko_mat2628335.Configuration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Call;

import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ParameterMode;
import java.net.URL;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

/**
 * 
 */
public class HLPManagementPeer {

   private static Configuration conf = new Configuration(Configuration.APPLICATION_SOAP_UNIT_TEST);

   public static IFManagementOperationResult setAccounts(IFAccountInfo accountInfo){
      IFManagementOperationResult result = null;
      try {
         String endPoint = Constants.SERVICE_ENDPOINT_WITNESS_MANAGER;
         System.setProperty("axis.ClientConfigFile", conf.getModuleUsageCounterHome() + "/WEB-INF/admin_management_config.wsdd");
         Service service = new Service();
         QName qnameRequest = new QName("http://diplom.compago.de", "AccountInfo");
         QName qnameResponse = new QName("http://diplom.compago.de", "ManagementOperationResult");
         Call call = (Call) service.createCall();
         call.setTargetEndpointAddress(new URL(endPoint));
         call.setOperationName("setAccounts");
         call.addParameter("request", qnameRequest, ParameterMode.IN);
         call.setReturnType(qnameResponse);
         result = (IFManagementOperationResult) call.invoke(new Object[]{accountInfo});
      } catch (ServiceException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      } catch (MalformedURLException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      } catch (RemoteException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
      return result;
   }

}
