package de.tu_dresden.diplom.richter_mirko_mat2628335.clients.context;

import org.apache.log4j.Logger;
import junit.framework.TestCase;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.CountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.CoordinationContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.StepContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.HandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.DigestAgreementRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.DigestAgreementResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.BodyEvidence;

/**
 * 
 */
public class UTClientContextManager extends TestCase {

   private static final Logger logger = Logger.getLogger(UTClientContextManager.class);

   private IFClientContextManager clientContextManager = null;

   private CountingContext createContextOperationCountingContext = null;
   private HandlingInfo createContextOperationHandlingInfo = null;
   private CountingContext startCommunicationCountingCtx = null;
   private DigestAgreementRequest startDigestAgreementRequestPhase = null;
   private DigestAgreementResponse completeDigestAgreementRequestPhase = null;

   private DigestAgreementRequest startDigestAgreementResponsePhase = null;
   private DigestAgreementResponse completeDigestAgreementResponsePhase = null;


   protected void setUp() throws Exception {
      clientContextManager = new ClientContextManager();
      {
         createContextOperationCountingContext = new CountingContext();
         CoordinationContext coordCtx = new CoordinationContext();
         coordCtx.setIdentification("ident#1");
         createContextOperationCountingContext.setCoordinationContext(coordCtx);
      }
      {
         createContextOperationHandlingInfo = new HandlingInfo();
         createContextOperationHandlingInfo.setCountingContext(createContextOperationCountingContext);
      }
      {
         startCommunicationCountingCtx = new CountingContext();
         CoordinationContext coordCtx = new CoordinationContext();
         {
            coordCtx.setIdentification("ident#1");
         }
         StepContext stepCtx = new StepContext();
         {
            stepCtx.setNonce("nonce#1");
         }
         startCommunicationCountingCtx.setCoordinationContext(coordCtx);
         startCommunicationCountingCtx.setStepContext(stepCtx);
      }
      {
         startDigestAgreementRequestPhase = new DigestAgreementRequest();
         startDigestAgreementRequestPhase.setContextID("ident#1");
         startDigestAgreementRequestPhase.setDigest("digestReq#1");
         startDigestAgreementRequestPhase.setNonce("nonce#1");
         startDigestAgreementRequestPhase.setRequestPhase();
      }
      {
         completeDigestAgreementRequestPhase = new DigestAgreementResponse();
         completeDigestAgreementRequestPhase.setAgreementReference("digestReq#1");
         completeDigestAgreementRequestPhase.setSuccess(true);
      }
      {
         startDigestAgreementResponsePhase = new DigestAgreementRequest();
         startDigestAgreementResponsePhase.setContextID("ident#1");
         startDigestAgreementResponsePhase.setDigest("digestReq#2");
         startDigestAgreementResponsePhase.setNonce("digestReq#1");
         startDigestAgreementResponsePhase.setResponsePhase();
      }
      {
         completeDigestAgreementResponsePhase = new DigestAgreementResponse();
         completeDigestAgreementResponsePhase.setAgreementReference("digestReq#2");
         completeDigestAgreementResponsePhase.setSuccess(true);
      }
   }

   public void testRegisterContext() {
      clientContextManager.registerContext(createContextOperationCountingContext, createContextOperationHandlingInfo);
      assertNotNull(clientContextManager.getContext(createContextOperationCountingContext.getIdentification()));
      assertNotNull(clientContextManager.getContext(createContextOperationCountingContext.getCoordinationContext()));
   }

   public void testRegisterCommunicationProcess(){
      clientContextManager.registerContext(createContextOperationCountingContext, createContextOperationHandlingInfo);
      assertTrue(clientContextManager.registerCommunicationStarted(startCommunicationCountingCtx));
      ((CoordinationContext)startCommunicationCountingCtx.getCoordinationContext()).setIdentification("wrongIdent");
      assertFalse(clientContextManager.registerCommunicationStarted(startCommunicationCountingCtx));
      assertFalse(clientContextManager.registerCommunicationStarted(null));
   }

   public void testDigestAgreement(){
      clientContextManager.registerContext(createContextOperationCountingContext, createContextOperationHandlingInfo);
      assertTrue(clientContextManager.registerCommunicationStarted(startCommunicationCountingCtx));
      String contextID = createContextOperationCountingContext.getIdentification();
      assertTrue(clientContextManager.registerDigestAgreementStarted(contextID, startDigestAgreementRequestPhase, startDigestAgreementRequestPhase.getNonce()));
      //registering the same again must fail!
      assertFalse(clientContextManager.registerDigestAgreementStarted(contextID, startDigestAgreementRequestPhase, startDigestAgreementRequestPhase.getNonce()));

      String nonce = startCommunicationCountingCtx.getStepContext().getNonce();
      assertTrue(clientContextManager.isRunningDigestAgreementRequestPhase(contextID, nonce));
      assertFalse(clientContextManager.isSuccessfullCompletedDigestAgreementRequestPhase(contextID, nonce));
      assertFalse(clientContextManager.isFailedDigestAgreementRequestPhase(contextID, nonce));
      assertFalse(clientContextManager.isRunningDigestAgreementResponsePhase(contextID, nonce));
      assertFalse(clientContextManager.isSuccessfullCompletedDigestAgreementResponsePhase(contextID, nonce));
      assertFalse(clientContextManager.isFailedDigestAgreementResponsePhase(contextID, nonce));

      assertFalse(clientContextManager.registerDigestAgreementStarted(contextID, startDigestAgreementResponsePhase, startDigestAgreementRequestPhase.getNonce()));
      assertTrue(clientContextManager.registerSuccessfullDigestAgreement(contextID, completeDigestAgreementRequestPhase, new BodyEvidence(null)));
      assertFalse(clientContextManager.isRunningDigestAgreementRequestPhase(contextID, nonce));
      assertTrue(clientContextManager.isSuccessfullCompletedDigestAgreementRequestPhase(contextID, nonce));
      assertFalse(clientContextManager.isFailedDigestAgreementRequestPhase(contextID, nonce));
      assertFalse(clientContextManager.isRunningDigestAgreementResponsePhase(contextID, nonce));
      assertFalse(clientContextManager.isSuccessfullCompletedDigestAgreementResponsePhase(contextID, nonce));
      assertFalse(clientContextManager.isFailedDigestAgreementResponsePhase(contextID, nonce));

      //assertTrue(clientContextManager.registerDigestAgreementStarted(contextID, startDigestAgreementResponsePhase));
   }

}
