package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFDigestAgreementConfirmationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.result.BaseResult;

/**
 * 
 */
public class DigestAgreementConfirmationResult extends BaseResult implements IFDigestAgreementConfirmationResult{

   private static final Logger logger = Logger.getLogger(DigestAgreementConfirmationResult.class);

   private String reference = null;

   public DigestAgreementConfirmationResult() {
      setResultCode(SUCCESS);
   }

   public boolean isSuccess() {
      //@TODO NO_ACCOUNT_TRANSFER_CONTEXT_FOUND in case no transfer-context defined or already executed in first
      //operation of both digestAgreementRequests
      return getResultCode() == SUCCESS || getResultCode() == NO_ACCOUNT_TRANSFER_CONTEXT_FOUND;
   }

   public boolean isFailure() {
      return !isSuccess() && !isUnknown();
   }

   public boolean isUnknown() {
      return getResultCode() == WAITING_FOR_SECOND_REQUEST;
   }

//   public boolean isFailureInProcess(){
//      return !isSuccess() && !isFailure() && !isUnknown();
//   }

   public String getReference() {
      return reference;
   }

   public void setReference(String reference) {
      this.reference = reference;
   }

   public String toString() {
      StringBuffer result = new StringBuffer("[DigestAgreementConfirmationResult::");
      result.append(" resultCode=").append(getResultCode());
      result.append(" | reference=").append(getReference());
      result.append(" | resultMessage=").append(getResultMessage());
      result.append("]");
      return result.toString();
   }
}
