package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextRemovalResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.ContextRemovalResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextRemovalRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.*;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.WitnessContextManager;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.WitnessContextManagerFactory;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.IFWitnessContextManager;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.IFWitnessContextInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.ex.ContextInfoInvalidException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFContextRemovalResult;

/**
 * 
 */
public class ContextRemovalProcess implements IFProcess {

   private static final Logger logger = Logger.getLogger(ContextRemovalProcess.class);

   private IFContextRemovalRequest contextRemovalRequest = null;
   private IFHandlingInfo handlingInfo = null;

   private IFContextRemovalResponse contextRemovalResponse = null;

   public ContextRemovalProcess(IFHandlingInfo handlingInfo, IFContextRemovalRequest contextRemovalRequest) {
      this.contextRemovalRequest = contextRemovalRequest;
      this.handlingInfo = handlingInfo;
   }

   public IFContextRemovalRequest getContextRemovalRequest() {
      return contextRemovalRequest;
   }

   protected void setContextRemovalResponse(IFContextRemovalResponse contextRemovalResponse) {
      this.contextRemovalResponse = contextRemovalResponse;
   }

   public IFHandlingInfo getHandlingInfo() {
      return handlingInfo;
   }

   public void perform() {
      final String fn = "[perform] ";
      ContextRemovalResponse contextRemovalResponse = new ContextRemovalResponse();
      setContextRemovalResponse(contextRemovalResponse);
      try {
         IFWitnessContextManager ctxManagerWitness = WitnessContextManagerFactory.getContextManager();
         if (logger.isDebugEnabled()) logger.debug(fn + "current contextManager:\n" + ctxManagerWitness);
         IFWitnessContextInfo belongingWitnessContextInfo = ctxManagerWitness.getContext(getHandlingInfo().getCountingContext().getCoordinationContext());
         if (belongingWitnessContextInfo != null) {
            if (logger.isDebugEnabled()) logger.debug(fn + "trying to remove context '" + belongingWitnessContextInfo + "'");
            if (getHandlingInfo().getSignatureHandlingInfoBody().getActingEntity().equals(belongingWitnessContextInfo.getOwningEntity())) {
               IFContextRemovalResult result = ctxManagerWitness.removeContext(belongingWitnessContextInfo);
               contextRemovalResponse.setResultMessage(result.getResultMessage());
               contextRemovalResponse.setResultCode(result.getResultCode());
            } else {
               contextRemovalResponse.setResultCode(IFContextRemovalResponse.WRONG_ENTITY);
               contextRemovalResponse.setResultMessage("wrong entity to remove the context!");
            }
         } else {
            logger.error(fn + "context to remove doesn't exist");
            contextRemovalResponse.setResultCode(IFContextRemovalResponse.CONTEXT_NOT_MANAGED);
            contextRemovalResponse.setResultMessage("context to remove doesn't exist");
         }
      } catch (ContextInfoInvalidException e) {
         logger.warn(fn + "operating on an invalidated context");
         contextRemovalResponse.setResultCode(IFContextRemovalResponse.CONTEXT_ALREADY_INVALID);
         contextRemovalResponse.setResultMessage("operating on an invalidated context");
      }
   }

   public IFContextRemovalResponse getContextRemovalResponse() {
      return contextRemovalResponse;
   }


}
