package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.evidence;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.IFWitnessContextInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.IFDigestAgreementProcess;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.ex.ContextInfoInvalidException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.BaseEvidenceManager;

import java.util.Map;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Vector;

/**
 * 
 */
public class WitnessEvidenceManager extends BaseEvidenceManager implements IFWitnessEvidenceManager{

   private static final Logger logger = Logger.getLogger(WitnessEvidenceManager.class);

   /**
    * maps from context-id to the IFContextInfo objects
    */
   private Map allContexts = null;

   /**
    * maps from ContextInfo objects to all DigestAgreementProcesses ever
    * finished successfully
    */
   private Map allAgreementProcesses = null;

   /**
    * maps from IFContextInfo-object to the evidence that the request for creating
    * the context came from the requester.
    */
   private Map contextCreationEvidence = null;

   protected WitnessEvidenceManager() {
      allContexts = new HashMap();
      allAgreementProcesses = new IdentityHashMap();
      contextCreationEvidence = new IdentityHashMap();
   }

   public void registerSuccessfullCreatedContext(IFWitnessContextInfo ctx, IFBodyEvidence bodyEvidence){
      final String fn = "[registerSuccessfullCreatedContext] ";
      try {
         if(ctx != null){
            String ident = ctx.getContextObject().getIdentification();
            if(ident != null && ident.length() > 0){
               if (logger.isDebugEnabled()) logger.debug(fn + "register context '" + ctx + "'");
               allContexts.put(ident, ctx);
               contextCreationEvidence.put(ctx, bodyEvidence);
            }else{
               logger.warn(fn + "context that has no identification or a zero-length identification can't be registered!");
            }
         }else{
            logger.warn(fn + "context that is NULL can't be registered!");
         }
      } catch (ContextInfoInvalidException e) {
         logger.fatal(fn + "context that is INVALID can not be registered!");
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
   }

   public void registerSuccessfullPerformedDigestAgreementProcess(IFWitnessContextInfo belongingWitnessContext, IFDigestAgreementProcess agreementProcess){
      if(isManaged(belongingWitnessContext)){
         Vector agreementProcesses = (Vector) allAgreementProcesses.get(belongingWitnessContext);
         if(agreementProcesses == null){
            agreementProcesses = new Vector();
            allAgreementProcesses.put(belongingWitnessContext, agreementProcesses);
         }
         agreementProcesses.add(agreementProcess);
      }
   }

   public boolean isManaged(IFWitnessContextInfo ctx){
      boolean result = false;
      result = allContexts.containsValue(ctx);
      return result;
   }
}
