package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.entity;

import org.apache.log4j.Logger;
import com.ibm.xml.dsig.KeyInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.keystore.ApplicationSpecificKeystoreUtility;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.EntityPool;

/**
 * 
 */
public class EntityManager implements IFEntityManager{

   private static final Logger logger = Logger.getLogger(EntityManager.class);

   protected EntityManager() {
   }

   public IFEntity locateEntity(KeyInfo keyInfo) {
      IFEntity result = null;
      if(keyInfo != null){
         if(keyInfo.getKeyValue() == null){
            result = locateEntityWithoutTransmittedKeyValue(keyInfo);
         }else{
            result = locateEntityWithTransmittedKeyValue(keyInfo);
         }
      }
      return result;
   }

   public IFEntity locateEntityByAlias(String alias){
      return EntityPool.getEntityByAlias(alias);
   }

   public IFEntity locateEntityById(int id){
      IFEntity result = null;
      result = EntityPool.getEntity(id);
      return result;
   }

   private IFEntity locateEntityWithoutTransmittedKeyValue(KeyInfo keyInfo) {
      final String fn = "[locateEntityWithoutTransmittedKeyValue]";
      IFEntity result = null;
      String[] keyNames = keyInfo.getKeyNames();
      if(keyNames.length == 1){
         String keyName = keyNames[0];
         if (logger.isDebugEnabled()) logger.debug(fn + " looking for entity '" + keyName + "' ...");
         result = EntityPool.getEntityByCertName(keyName);
         if (logger.isDebugEnabled()) logger.debug(fn + " ... found entity '" + result + "'");
      }else{
         logger.error(fn + " zero or more than one keyName given!");
      }
      return result;
   }

   private IFEntity locateEntityWithTransmittedKeyValue(KeyInfo keyInfo) {
      IFEntity result = null;
      return result;
   }


}
