package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.dependency;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency.IFSOAPDependency;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFDigestAgreementConfirmationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFDigestAgreementConfirmationResult;

/**
 * 
 */
public interface IFDependencyManager {

   /**
    * Checks wheather the dependency can be met or not. Does not make any changes to
    * the currently hold dependencies.
    *
    * @param dependency
    * @return
    */
   public boolean checkDependency(IFSOAPDependency dependency);

   /**
    * Adds the given dependency into the dependency-chain of this dependencyManager.
    *
    * @param dependency
    * @param confirmationResult
    */
   public void addConfirmedDependency(IFSOAPDependency dependency, IFDigestAgreementConfirmationResult confirmationResult);

   public boolean isEqual(IFSOAPDependency first, IFSOAPDependency second);
}
