package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCoordinationContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.ex.UnknownEntityException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFDigestAgreementConfirmationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFContextRemovalResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;

/**
 * 
 */
public interface IFWitnessContextManager {

   /**
    * Register a new context.
    * @param coordinationContext contains informations belonging to the whole communication (several steps with probably more than one service)
    * @param request the context-creation request of the user
    * @param signatureHandlingInfo the information extracted by the axis-handlers (who signed? encrypted? ...)
    * @return
    */
   public IFWitnessContextInfo registerContext(IFCoordinationContext coordinationContext, IFContextCreationRequest request, IFSignatureHandlingInfo signatureHandlingInfo) throws UnknownEntityException;

   /**
    * get the internal managed contextInfo object belonging to the given coordinationContext
    * @param coordinationContext
    * @return
    */
   public IFWitnessContextInfo getContext(IFCoordinationContext coordinationContext);

   public IFWitnessContextInfo getContext(String ident);

   public IFContextRemovalResult removeContext(IFWitnessContextInfo context2Remove);

   public boolean registerDigestAgreementRequest(IFDigestAgreementRequest digestAgreementRequest, IFEntity actingEntity, IFBodyEvidence evidence);

   /**
    * Checks wheather 2 requests with the same nonce-value and the same digest exist.<br/>
    * If the result ist SUCCESS or FAILURE the <b>process is beeing deleted</b> if both parties
    * have requested the confirmation-result by calling this method with the apropriate digestAgreementRequest.
    * @param digestAgreementRequest
    * @return
    */
   public IFDigestAgreementConfirmationResult getConfirmationState(IFDigestAgreementRequest digestAgreementRequest);
}
