package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCoordinationContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFContextInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account.IFAccountTransferContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account.IFAccount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.dependency.IFDependencyManager;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.ex.ContextInfoInvalidException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;

/**
 * 
 */
public interface IFWitnessContextInfo extends IFContextInfo{

   public boolean isSuccessfulCreated() throws ContextInfoInvalidException;

   public IFCoordinationContext getContextObject() throws ContextInfoInvalidException;
   public IFAccount getSourceAccount() throws ContextInfoInvalidException;

   public IFDependencyManager getDependencyManager() throws ContextInfoInvalidException;

   public IFDigestAgreementProcess getDigestAgreementProcess(String ident) throws ContextInfoInvalidException;
   public void removeDigestAgreementProcess(String ident) throws ContextInfoInvalidException;
   public void addDigestAgreementProcess(String ident, IFDigestAgreementProcess digAgreeProc) throws ContextInfoInvalidException;

   public void setInvalid(String invalidityReason) throws ContextInfoInvalidException;
   public boolean isInvalid();
   public String getInvalidityReason();

   public IFEntity getOwningEntity() throws ContextInfoInvalidException;

   public boolean hasOpenAccountTransferContexts() throws ContextInfoInvalidException;
   public void addAccountTransferContext(String reference, IFAccountTransferContext accountTransferContext);
   public IFAccountTransferContext getAccountTransferContext(String reference);
   public void removeAccountTransferContext(String reference);
}
