package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAmount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfoItem;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;

/**
 * 
 */
public interface IFAccountManager {

   public IFAccount locateAccount(IFEntity entity, IFAccountIdentification accountIdent);
   public IFAccount[] locateAccounts(IFEntity entity);

   /**
    * Get detailed information on accounts belonging to the given entity.
    * @param entity
    * @return
    */
   public IFAccountInfoItem[] locateAccountInfos(IFEntity entity);

   /**
    * Changes the specified account (entityId, accountId) to the new amount (newAmount).<br/>
    * If the Account doesn't exist it is beeing created.
    * @param entityId
    * @param accountId
    * @param newAmount
    */
   //public void changeAccount(int entityId, IFAccountIdentification accountId, IFAmount newAmount);

   /**
    * Changes the specified account (entityId, accountId) to the new amount (newAmount).<br/>
    * If the Account doesn't exist it is beeing created.
    * @param entity
    * @param accountId
    * @param newAmount
    */
   public void changeAccount(IFEntity entity, IFAccountIdentification accountId, IFAmount newAmount);

   /**
    * Creates a new Account according to the given accountIdentification and the new Amount and
    * registrates it as a new Account to the given entity.<br/>
    * Already existing accounts with the same identification will be overwritten.
    * @param entity
    * @param accountID
    * @param newAmount
    */
   public void createAccount(IFEntity entity, IFAccountIdentification accountID, IFAmount newAmount);
}
