package de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.entity.EntityManagerFactory;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAmount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfoItem;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfoItem;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;

/**
 * 
 */
public class AccountManager implements IFAccountManager{

   private static final Logger logger = Logger.getLogger(AccountManager.class);

   protected AccountManager() {
   }

   public IFAccount locateAccount(IFEntity entity, IFAccountIdentification accountIdent) {
      IFAccount result = null;
      result = AccountPool.getAccount(entity, accountIdent);
      return result;
   }

   public IFAccount[] locateAccounts(IFEntity entity){
      IFAccount[] result = null;
      result = AccountPool.getAccounts(entity);
      return result;
   }

   public IFAccountInfoItem[] locateAccountInfos(IFEntity entity){
      IFAccountInfoItem[] result = null;
      result = AccountPool.getAccountInfos(entity);
      return result;
   }

   public void changeAccount(int entityId, IFAccountIdentification accountId, IFAmount newAmount){
      IFEntity entity = EntityManagerFactory.getEntityManager().locateEntityById(entityId);
      changeAccount(entity, accountId, newAmount);
   }

   public void changeAccount(IFEntity entity, IFAccountIdentification accountId, IFAmount newAmount){
      final String fn = "[setAccount] ";
      if(entity != null && accountId != null && newAmount != null){
         IFAccount targetAccount = locateAccount(entity, accountId);
         if(targetAccount != null){
            if(logger.isDebugEnabled())logger.debug(fn + "account found ... trying to set new Amount ...");
            if(targetAccount instanceof IFAccountModifieable){
               ((IFAccountModifieable)targetAccount).setAmount(newAmount);
               if(logger.isDebugEnabled())logger.debug(fn + "... success!");
            }else{
               if(logger.isInfoEnabled())logger.info(fn + "... couldn't set the new amount because Account is modifieable!");
            }
         }else{
            if(logger.isInfoEnabled())logger.info(fn + "account didn't exist ... creating a new one!");
            createAccount(entity, accountId, newAmount);
         }
      }else{
         StringBuffer err = new StringBuffer("PARAM CHECK FAILED: ");
         if(entity == null){
            err.append("entity was NULL!");
         }else if(accountId == null){
            err.append("accountId was NULL!");
         }else if(newAmount == null){
            err.append("newAmount was NULL!");
         }
         logger.error(fn + err);
      }
   }

   public void createAccount(int entityId, IFAccountIdentification accountId, IFAmount newAmount){
      IFEntity entity = EntityManagerFactory.getEntityManager().locateEntityById(entityId);
      createAccount(entity, accountId, newAmount);
   }

   public void createAccount(IFEntity entity, IFAccountIdentification accountId, IFAmount newAmount){
      AccountPool.createAccount(entity, accountId, newAmount);
   }
}
