package de.tu_dresden.diplom.richter_mirko_mat2628335.witness;

import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.axis.MessageContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.*;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm.IFContextCreationResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.IFWitnessContextInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.WitnessContextManagerFactory;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.context.IFWitnessContextManager;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.result.IFDigestAgreementConfirmationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.ContextCreationProcess;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.process.DigesterProcess;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.BaseHandler;

/**
 * 
 */
public class Witness {

   private static final Logger logger = Logger.getLogger(Witness.class);

   public static final String PROP_MESSAGECONTEXT_CONTEXTCREATIONRESPONSE = "contextCreated";


   public IFContextCreationResponse createContext(IFContextCreationRequest request) {
      final String fn = "[createContext]";
      MDC.put("logInfo", "Witness.RequestContext.Pivot");
      //SOAPContextCreationResponse response = null;
      MessageContext messageContext = MessageContext.getCurrentContext();
      IFHandlingInfo handlingInfo = BaseHandler.getHandlingInfo();
      IFContextCreationResponse result = null;
      try {
         ContextCreationProcess contextCreationProcess = new ContextCreationProcess(handlingInfo, request);
         contextCreationProcess.perform();
         if (contextCreationProcess.isSuccess()) {
            messageContext.setProperty(PROP_MESSAGECONTEXT_CONTEXTCREATIONRESPONSE, contextCreationProcess.getHeaderResponse());
         }
         result = contextCreationProcess.getContextCreationResponse();
      } catch (Exception ex) {
         ex.printStackTrace();
      }

      MDC.remove("logInfo");
      return result;
   }

   public IFDigestAgreementResponse performDigestAgreement(IFDigestAgreementRequest request) {
      final String fn = "[performDigestAgreement]";
      MDC.put("logInfo", "Witness.DigestAgreement.Pivot");
      //MessageContext messageContext = MessageContext.getCurrentContext();
      IFHandlingInfo handlingInfo = BaseHandler.getHandlingInfo();
      IFDigestAgreementResponse result = null;
      try {
         DigesterProcess digesterProcess = new DigesterProcess(handlingInfo, request);
         digesterProcess.perform();
         result = digesterProcess.getDigestAgreementResponse();
      } catch (Exception ex) {
         ex.printStackTrace();
      }
      MDC.remove("logInfo");
      return result;
   }
}
