package de.tu_dresden.diplom.richter_mirko_mat2628335.witness;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfoItem;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfoItem;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.management.IFManagementOperationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.management.ManagementOperationResult;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.BaseHandler;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.AccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.entity.EntityManagerFactory;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account.AccountManagerFactory;

/**
 * 
 */
public class ManagerService {

   private static final Logger logger = Logger.getLogger(ManagerService.class);

   public IFManagementOperationResult setAccounts(IFAccountInfo accountInfo){
      final String fn = "[setAccounts] ";
      ManagementOperationResult result = new ManagementOperationResult();
      try {
         IFHandlingInfo handlingInfo = BaseHandler.getHandlingInfo();
         if(accountInfo != null &&
              handlingInfo != null && handlingInfo.isSuccess() &&
              handlingInfo.getSignatureHandlingInfoBody() != null &&
              handlingInfo.getSignatureHandlingInfoBody().getActingEntity() != null &&
              handlingInfo.getSignatureHandlingInfoBody().getActingEntity().equals(EntityManagerFactory.getEntityManager().locateEntityByAlias("Client1"))){
            IFAccountInfoItem[] items = accountInfo.getAccountInfoItems();
            if(logger.isDebugEnabled())logger.debug(fn + "setting accounts...");
            if(items != null && items.length > 0){
               for (int i = 0; i < items.length; i++) {
                  IFAccountInfoItem item = items[i];
                  if(item != null){
                     IFEntity targetEntity = EntityManagerFactory.getEntityManager().locateEntityById(item.getOwnerIdentityID());
                     AccountManagerFactory.getAccountManager().changeAccount(targetEntity, new AccountIdentification(item.getAccountID()), item.getAmount());
                     result.setResultCode(IFManagementOperationResult.SUCCESS);
                  }else{
                     logger.warn(fn + "can't set NULL-item (array-pos '" + i + "')");
                  }
               }
            }else{
               if(logger.isInfoEnabled())logger.info(fn + "...no items to set.");
            }
         }else{
            StringBuffer err = new StringBuffer("CHECK FOR PARAMS FAILED: ");
            if(accountInfo == null){
               err.append("accountInfo was NULL!");
            }else if(handlingInfo == null){
               err.append("handlingInfo was NULL!");
            }else if(!handlingInfo.isSuccess()){
               err.append("handlingInfo wasn't successful!");
            }else if(handlingInfo.getSignatureHandlingInfoBody() == null){
               err.append("cryptHandlingInfoBody was NULL!");
            }else if(handlingInfo.getSignatureHandlingInfoBody().getActingEntity() == null){
               err.append("actingEntity was NULL!");
            }else if(!handlingInfo.getSignatureHandlingInfoBody().getActingEntity().equals(EntityManagerFactory.getEntityManager().locateEntityByAlias("Admin"))){
               err.append("actingEntity wasn't entity ADMIN!");
            }
            logger.error(fn + err);
         }
      } catch (Exception e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
      return result;
   }

}
