package de.tu_dresden.diplom.richter_mirko_mat2628335.witness;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.AccountInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfoItem;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.account.IFAccountInfoItem;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.info.context.IFContextInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.HandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.BaseHandler;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account.IFAccount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.witness.account.AccountManagerFactory;

/**
 * Informationservice to obtain data about the state of some process, account etc.
 */
public class InfoService {

   private static final Logger logger = Logger.getLogger(InfoService.class);

   public IFAccountInfo getAccountInfo(){
      final String fn = "[getAccountInfo] ";
      AccountInfo result = null;
      IFHandlingInfo handlingInfo = BaseHandler.getHandlingInfo();
      if(handlingInfo != null && handlingInfo.isSuccess() && handlingInfo.getSignatureHandlingInfoBody() != null && handlingInfo.getSignatureHandlingInfoBody().getActingEntity() != null){
         if (logger.isDebugEnabled()) logger.debug(fn + "aquiring AccountInfo for entity '" + handlingInfo.getSignatureHandlingInfoBody().getActingEntity() + "'...");
         IFAccountInfoItem[] accountInfos = AccountManagerFactory.getAccountManager().locateAccountInfos(handlingInfo.getSignatureHandlingInfoBody().getActingEntity());
         if(accountInfos != null && accountInfos.length > 0){
            if(logger.isDebugEnabled())logger.debug(fn + "... found " + accountInfos.length + " accounts");
            result = new AccountInfo();
            result.setAccountInfoItems(accountInfos);
         }else{
            if(logger.isDebugEnabled())logger.debug(fn + "... found no accounts");
         }
      }else{
         StringBuffer err = new StringBuffer("CHECK FOR PARAMS FAILED: ");
         if(handlingInfo == null){
            err.append("handlingInfo was NULL!");
         }else if(!handlingInfo.isSuccess()){
            err.append("handlingInfo wasn't successful!");
         }else if(handlingInfo.getSignatureHandlingInfoBody() == null){
            err.append("cryptHandlingInfoBody was NULL!");
         }else if(handlingInfo.getSignatureHandlingInfoBody().getActingEntity() == null){
            err.append("actingEntity was NULL!");
         }
         logger.error(fn + err);
      }
      return result;
   }

   public IFContextInfo getContextInfo(){
      final String fn = "[getContextInfo] ";
      IFContextInfo result = null;
      IFHandlingInfo handlingInfo = BaseHandler.getHandlingInfo();
      if(handlingInfo != null && handlingInfo.isSuccess() && handlingInfo.getSignatureHandlingInfoBody() != null && handlingInfo.getSignatureHandlingInfoBody().getActingEntity() != null){
         if (logger.isDebugEnabled()) logger.debug(fn + "aquiring ContextInfo for entity '" + handlingInfo.getSignatureHandlingInfoBody().getActingEntity() + "'...");
      }else{
         StringBuffer err = new StringBuffer("CHECK FOR PARAMS FAILED: ");
         if(handlingInfo == null){
            err.append("handlingInfo was NULL!");
         }else if(!handlingInfo.isSuccess()){
            err.append("handlingInfo wasn't successful!");
         }else if(handlingInfo.getSignatureHandlingInfoBody() == null){
            err.append("cryptHandlingInfoBody was NULL!");
         }else if(handlingInfo.getSignatureHandlingInfoBody().getActingEntity() == null){
            err.append("actingEntity was NULL!");
         }
         logger.error(fn + err);
      }
      return result;
   }

}
