package de.tu_dresden.diplom.richter_mirko_mat2628335.services.handler;

import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.axis.MessageContext;
import org.apache.axis.AxisFault;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.BaseHandler;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.services.context.ServiceContextManagerFactory;
import de.tu_dresden.diplom.richter_mirko_mat2628335.services.context.IFServiceContextInfo;

/**
 * 
 */
public class ServiceContextManagerFeeder extends BaseHandler {

   private static final Logger logger = Logger.getLogger(ServiceContextManagerFeeder.class);

   public void invoke(MessageContext messageContext) throws AxisFault {
      final String fn = "[invoke] ";
      String logInfo = (String) getOption("logInfo");
      if(logInfo != null){
         //fn = fn + " -> " + logInfo + "::";
         MDC.put("logInfo", logInfo);
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " --> SERVICECONTEXTMANAGERFEEDER");
      IFHandlingInfo handlingInfo = getHandlingInfo();
      if (handlingInfo != null) {
         IFCountingContext countingCtx = handlingInfo.getCountingContext();
         if (countingCtx != null) {
            IFServiceContextInfo serviceCtxInfo = ServiceContextManagerFactory.getContextManager().registerContext(countingCtx, handlingInfo);
         }else{
            logger.error(fn + "the Handling-Info-Object contained no CountingContext!");
         }
      }else{
         logger.error(fn + "couldn't find the HandlingInfo-object associated to this Thread!");
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " <-- SERVICECONTEXTMANAGERFEEDER");
      MDC.remove("logInfo");
   }
}
