package de.tu_dresden.diplom.richter_mirko_mat2628335.common.listener.event;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext;
import org.apache.log4j.Logger;

/**
 * 
 */
public class CommunicationInitiatedEvent implements IFCommunicationInitiatedEvent{

   private final Logger logger = Logger.getLogger(CommunicationInitiatedEvent.class);

   private String identification = null;
   private String stepNonce = null;

   public CommunicationInitiatedEvent(IFCountingContext countingCtx) {
      final String fn = "[<init>]";
      if(countingCtx != null){
         setIdentification(countingCtx.getIdentification());
         if(countingCtx.getStepContext() != null){
            setStepNonce(countingCtx.getStepContext().getNonce());
         }else{
            logger.warn(fn + "PARAM CHECK FAILED: stepCtx was NULL!");
         }
         if(countingCtx.getCoordinationContext() != null){
            //countingCtx.getCoordinationContext().getCoordinationType();
         }else{
            logger.warn(fn + "PARAM CHECK FAILED: coordinationCtx was NULL!");
         }
      }else{
         logger.warn(fn + "PARAM CHECK FAILED: countingCtx was NULL!");
      }

   }

   public String getStepNonce() {
      return stepNonce;
   }

   public void setStepNonce(String stepNonce) {
      this.stepNonce = stepNonce;
   }

   public String getIdentification() {
      return identification;
   }

   public void setIdentification(String identification) {
      this.identification = identification;
   }

}
