package de.tu_dresden.diplom.richter_mirko_mat2628335.common.listener;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.listener.event.IFCommunicationInitiatedEvent;
import org.apache.log4j.Logger;

/**
 * 
 */
public class LoggingCommunicationInitiatedListener implements IFCommunicationInitiatedListener{

   private Logger logger = Logger.getLogger(LoggingCommunicationInitiatedListener.class);
   private Logger listenerMonitor = Logger.getLogger("monitor.listener.communication");

   public void eventOccurred(IFCommunicationInitiatedEvent ev) {
      final String fn = "[eventOccurred] ";
      if(ev != null){
         if(listenerMonitor.isDebugEnabled()){
            StringBuffer mon = new StringBuffer("CommunicationInitiatedEvent caught:\n");
            mon.append("\tIdentification:\t").append(ev.getIdentification()).append("\n");
            mon.append("\tStepNonce:\t").append(ev.getStepNonce()).append("\n");
            listenerMonitor.debug(fn + mon);
         }
      }
   }

}
