package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.result.IFBaseResult;

/**
 * Some parts of any incomming request may be signed. The operations
 * to validate the signature are implemented as axis-handlers and
 * the information (who, with what key etc.) is safed to this object and made
 * available to the Pivot-Service.<br/>
 * These Informations are needed for the internal Handling of the SOAP-Message, f.e.
 * to be sure that on context-creation the entity who signed the request is
 * the same that is supposed to be the owner of the context.
 */
public interface IFSignatureHandlingInfo extends IFCryptHandlingInfo{

   /**
    * Indigates as result-code that the signature for the target-element could
    * not be found
    */
   public static final int NO_SIGNATURE_EXISTENT = CUSTOM_START + 1;

   /**
    * Gets the entity that performed or shall perform the signature.
    * @return
    */
   public IFEntity getActingEntity();

   /**
    * Sets the entity the performed ao shall perform the signature.
    * @param entity
    */
   public void setActingEntity(IFEntity entity);
}
