package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.result.IFBaseResult;

/**
 * Interface that represents all collected informations (signature. encryption etc.)
 * that was collected while going through the configured axis-handler-chain.
 */
public interface IFHandlingInfo extends IFBaseResult{

   /**
    * Indicates as result-code that the counting-context-element could not be found
    */
   public static final int COUNTING_CONTEXT_NOT_FOUND = CUSTOM_START + 1;

   /**
    * Indicates as result-code that the coordination-context-element could not be found
    */
   public static final int COORDINATION_CONTEXT_NOT_FOUND = CUSTOM_START + 2;

   /**
    * Indicates as result-code that the step-context-element could not be found
    */
   public static final int STEP_CONTEXT_NOT_FOUND = CUSTOM_START + 3;

   /**
    * Gets the information that were collected while validating the signature of the
    * counting-context-element
    * @return The collected information
    */
   public IFSignatureHandlingInfo getSignatureHandlingInfoCountingContext();

   /**
    * Gets the information that were collected while validating the signature of the
    * cordination-context-element
    * @return The collected information
    */
   public IFSignatureHandlingInfo getSignatureHandlingInfoCoordinationContext();

   /**
    * Gets the information that were collected while validating the signature of the
    * step-context-element
    * @return The collected information
    */
   public IFSignatureHandlingInfo getSignatureHandlingInfoStepContext();

   /**
    * Gets the information that were collected while validating the signature of the
    * body-element
    * @return The collected information
    */
   public IFSignatureHandlingInfo getSignatureHandlingInfoBody();

   /**
    * Gets the information that were collected while encrypting/decrypting the
    * counting-context-element
    * @return The collected information
    */
   public IFEncryptionHandlingInfo getEncryptionHandlingInfoCountingContext();

   /**
    * Gets the information that were collected while encrypting/decrypting the
    * body-element
    * @return The collected information
    */
   public IFEncryptionHandlingInfo getEncryptionHandlingInfoBody();

   /**
    * Gets the counting-context from the SOAP-Message
    * @return The counting-context-elemnt
    */
   public IFCountingContext getCountingContext();

   /**
    * Sets the counting-context-element
    * @param context The counting-context to be set.
    */
   public void setCountingContext(IFCountingContext context);

   /**
    * Sets the result-code for this handling-info-object.
    * @param resultCode
    */
   public void setResultCode(int resultCode);

   /**
    * Sets the result-message in this handling-info-object.
    * @param msg
    */
   public void setResultMessage(String msg);
}
