package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.SignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.*;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.result.BaseResult;

/**
 * Class that represents the handlingInfo that is being collected while going through
 * the chain of axis-handlers.
 */
public class HandlingInfo extends BaseResult implements IFHandlingInfo{

   private static final Logger logger = Logger.getLogger(HandlingInfo.class);

   private IFSignatureHandlingInfo signatureHandlingInfoCountingContext = null;

   /**
    * contains handling-information belonging to the state (enc, sign) of the context
    */
   private IFSignatureHandlingInfo signatureHandlingInfoCoordinationContext = null;
   private IFSignatureHandlingInfo signatureHandlingInfoStepContext = null;
   private IFSignatureHandlingInfo signatureHandlingInfoBody = null;

   private IFEncryptionHandlingInfo encryptionHandlingInfoCountingContext = null;
   private IFEncryptionHandlingInfo encryptionHandlingInfoBody = null;

   private IFCountingContext countingContext = null;

   public HandlingInfo() {
      setResultCode(SUCCESS);
   }

   /**
    * @see IFHandlingInfo#getSignatureHandlingInfoCountingContext()
    */
   public IFSignatureHandlingInfo getSignatureHandlingInfoCountingContext() {
      if(signatureHandlingInfoCountingContext == null){
         signatureHandlingInfoCountingContext = new SignatureHandlingInfo();
      }
      return signatureHandlingInfoCountingContext;
   }

   /**
    * @see IFHandlingInfo#getSignatureHandlingInfoCoordinationContext()
    */
   public IFSignatureHandlingInfo getSignatureHandlingInfoCoordinationContext() {
      if(signatureHandlingInfoCoordinationContext == null){
         signatureHandlingInfoCoordinationContext = new SignatureHandlingInfo();
      }
      return signatureHandlingInfoCoordinationContext;
   }

   /**
    * @see IFHandlingInfo#getSignatureHandlingInfoStepContext()
    */
   public IFSignatureHandlingInfo getSignatureHandlingInfoStepContext() {
      if(signatureHandlingInfoStepContext == null){
         signatureHandlingInfoStepContext = new SignatureHandlingInfo();
      }
      return signatureHandlingInfoStepContext;
   }

   /**
    * @see IFHandlingInfo#getSignatureHandlingInfoBody()
    */
   public IFSignatureHandlingInfo getSignatureHandlingInfoBody() {
      if(signatureHandlingInfoBody == null){
         signatureHandlingInfoBody = new SignatureHandlingInfo();
      }
      return signatureHandlingInfoBody;
   }

   /**
    * @see IFHandlingInfo#getEncryptionHandlingInfoCountingContext()
    */
   public IFEncryptionHandlingInfo getEncryptionHandlingInfoCountingContext() {
      if(encryptionHandlingInfoCountingContext == null){
         encryptionHandlingInfoCountingContext = new EncryptionHandlingInfo();
      }
      return encryptionHandlingInfoCountingContext;
   }

   /**
    * @see IFHandlingInfo#getEncryptionHandlingInfoBody()
    */
   public IFEncryptionHandlingInfo getEncryptionHandlingInfoBody() {
      if(encryptionHandlingInfoBody == null){
         encryptionHandlingInfoBody = new EncryptionHandlingInfo();
      }
      return encryptionHandlingInfoBody;
   }

   /**
    * @see IFHandlingInfo#getCountingContext()
    */
   public IFCountingContext getCountingContext() {
      return countingContext;
   }

   /**
    * @see IFHandlingInfo#setCountingContext(de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext)
    */
   public void setCountingContext(IFCountingContext countingContext) {
      this.countingContext = countingContext;
   }

   /**
    * @see de.tu_dresden.diplom.richter_mirko_mat2628335.common.result.IFBaseResult#isSuccess()
    */
   public boolean isSuccess() {
      return getResultCode() == SUCCESS;
   }

   /**
    * @see de.tu_dresden.diplom.richter_mirko_mat2628335.common.result.IFBaseResult#isFailure() 
    */
   public boolean isFailure() {
      return !isSuccess();
   }

}
