package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler;

import org.apache.axis.MessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.MDC;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFSignatureHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.crypto.SignUtil;

/**
 * 
 */
public class CountingContextSigner extends BaseSigner{

   private static final Logger logger = Logger.getLogger(CountingContextSigner.class);

   /**
    * @see org.apache.axis.Handler#invoke(org.apache.axis.MessageContext)
    */
   public void invoke(MessageContext messageContext) throws AxisFault {
      String fn = "[invoke] ";
      String logInfo = (String) getOption(OPTION_LOG_INFO);
      if (logInfo != null) {
         MDC.put(OPTION_LOG_INFO, logInfo);
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " --> COUNTINGCONTEXTSIGNER");
      super.invoke(messageContext);
      if (getHandlingInfo().isSuccess()) {
         IFEntity signingEntity = getSigningEntity();
         if (logger.isDebugEnabled()) logger.debug(fn + " signing with entity '" + signingEntity + "'");
         if (isXSS4JEnveloped()) {
            signCountingContextEnvelopedXSS4J(messageContext, signingEntity);
         } else if (isTSIKWSSEC()) {

         } else {
            logger.error(fn + "signature-mechanism unknown");
         }
      } else {
         logger.fatal(fn + "Didn't perform operation because HandlingInfo FAILED!");
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " <-- COUNTINGCONTEXTSIGNER!");
      MDC.remove(OPTION_LOG_INFO);
   }

   private void signCountingContextEnvelopedXSS4J(MessageContext messageContext, IFEntity signingEntity) {
      final String fn = "[signCountingContextEnvelopedXSS4J] ";
      try {
         Message msg = messageContext.getCurrentMessage();
         SOAPEnvelope soapEnvelope = msg.getSOAPEnvelope();
         Document doc = soapEnvelope.getAsDocument();
         SignUtil.signEnvelopedXSS4J(doc, getCountingContextElement(doc), signingEntity);
      } catch (Exception e) {
         logger.fatal(fn + "error while signing countingContext!");
         e.printStackTrace();
      }
   }

   public IFEntity getSigningEntityFromHandlingInfo() {
      final String fn = "[getSigningEntityFromHandlingInfo] ";
      IFEntity result = null;
      IFHandlingInfo handlingInfo = getHandlingInfo();
      if(handlingInfo != null){
         IFSignatureHandlingInfo sigHandlInf = handlingInfo.getSignatureHandlingInfoCountingContext();
         if(sigHandlInf != null){
            result = sigHandlInf.getActingEntity();
         }else{
            logger.warn(fn + "No signatureHandlingInfo set for CountingContext in currentThread's handlingInfo!");
         }
      }else{
         logger.warn(fn + "No handlingInfo set in currentThread!");
      }
      return result;
   }

}
