package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler;

import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.axis.MessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.w3c.dom.Element;

import javax.xml.soap.SOAPException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPHeaderElement;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.NS;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.CountingContext;

import java.util.Iterator;

/**
 * 
 */
public class CountingContextReader extends BaseContextHandler {

   private static final Logger logger = Logger.getLogger(CountingContextReader.class);

   /**
    * @see org.apache.axis.Handler#invoke(org.apache.axis.MessageContext)
    */
   public void invoke(MessageContext messageContext) throws AxisFault {
      String fn = "[invoke]";
      String logInfo = (String) getOption(OPTION_LOG_INFO);
      if (logInfo != null) {
         //fn = fn + " -> " + logInfo + "::";
         MDC.put(OPTION_LOG_INFO, logInfo);
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " --> COUNTINGCONTEXTREADER");
      IFHandlingInfo handlingInfo = getHandlingInfo();
      if (handlingInfo.isSuccess()) {
         try {
            if (handlingInfo.getSignatureHandlingInfoCoordinationContext().isSuccess()) {
               if (logger.isDebugEnabled()) logger.debug(fn + "");
               Element context = getCountingContextElement(messageContext.getCurrentMessage());
               CountingContext contextObj = new CountingContext();
               contextObj.setContextElement(context);
               handlingInfo.setCountingContext(contextObj);
            } else {
               logger.error(fn + "Validation of Context-Signature has failed! Not Reading CountingContext!");
            }
         } catch (Exception e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
         }
         try {
            eraseContextMustUnderstandAttribute(messageContext.getCurrentMessage());
         } catch (SOAPException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
         }
      } else {
         logger.fatal(fn + "Didn't perform operation because HandlingInfo FAILED (was '" + handlingInfo.getResultCode() + "')!");
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " <-- COUNTINGCONTEXTREADER");
      MDC.remove(OPTION_LOG_INFO);
   }

   protected void eraseContextMustUnderstandAttribute(Message message) throws SOAPException, AxisFault {
      final String fn = "[eraseContextMustUnderstandAttribute]";
      SOAPEnvelope soapEnvelope = message.getSOAPEnvelope();
      if (logger.isDebugEnabled()) logger.debug(fn + " setting mustUnderstand-Attribute to FALSE ...");
      Name coordCon = soapEnvelope.createName(Constants.ELEMENT_NAME_COUNTING_CONTEXT, NS.ACCESS_CONTROL_PROTOTYP_PREFIX, NS.ACCESS_CONTROL_PROTOTYP_NAMESPACE);
      Iterator it = soapEnvelope.getHeader().getChildElements(coordCon);
      while (it.hasNext()) {
         SOAPHeaderElement elem = (SOAPHeaderElement) it.next();
         elem.setMustUnderstand(false);
         //System.out.println(elem.getNodeName());
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " ... done");
   }
}
