package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler;

import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.axis.MessageContext;
import org.apache.axis.AxisFault;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFEncryptionHandlingInfo;

/**
 * 
 */
public class CountingContextEncrypter extends BaseEncrypter {

   private static final Logger logger = Logger.getLogger(CountingContextEncrypter.class);

   /**
    * @see org.apache.axis.Handler#invoke(org.apache.axis.MessageContext)
    */
   public void invoke(MessageContext messageContext) throws AxisFault {
      String fn = "[invoke] ";
      String logInfo = (String) getOption(OPTION_LOG_INFO);
      if (logInfo != null) {
         MDC.put(OPTION_LOG_INFO, logInfo);
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " --> COUNTINGCONTEXTENCRYPTER");
      super.invoke(messageContext);
      if (getHandlingInfo().isSuccess()) {
         if (ENCRYPTION_ENABLED) {
            if (logger.isInfoEnabled()) logger.info(fn + "Encryption global ENABLED!");
         } else {
            if (logger.isInfoEnabled()) logger.info(fn + "Encryption global DISABLED!");
         }
      } else {
         logger.fatal(fn + "Didn't perform operation because HandlingInfo FAILED!");
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " <-- COUNTINGCONTEXTENCRYPTER!");
      MDC.remove(OPTION_LOG_INFO);
   }

   public IFEntity getEncryptingEntityFromHandlingInfo() {
      final String fn = "[getEncryptingEntityFromHandlingInfo] ";
      IFEntity result = null;
      IFHandlingInfo handlingInfo = getHandlingInfo();
      if (handlingInfo != null) {
         IFEncryptionHandlingInfo encHandlInf = handlingInfo.getEncryptionHandlingInfoCountingContext();
         if (encHandlInf != null) {
            result = encHandlInf.getEncryptingEntity();
         } else {
            logger.warn(fn + "No encryptionHandlingInfo set for CountingContext in currentThread's handlingInfo!");
         }
      } else {
         logger.warn(fn + "No handlingInfo set in currentThread!");
      }
      return result;
   }
}
