package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.crypto.VerifyUtil;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.w3c.dom.Element;

/**
 * 
 */
public class BodySignatureValidator extends BaseSignatureValidator {

   private static final Logger logger = Logger.getLogger(BodySignatureValidator.class);

   /**
    * @see org.apache.axis.Handler#invoke(org.apache.axis.MessageContext)
    */
   public void invoke(MessageContext messageContext) throws AxisFault {
      String fn = "[invoke]";
      String logInfo = (String) getOption(OPTION_LOG_INFO);
      if (logInfo != null) {
         //fn = fn + " -> " + logInfo + "::";
         MDC.put(OPTION_LOG_INFO, logInfo);
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " --> BODYSIGNATUREVALIDATOR");
      super.invoke(messageContext);
      try {
         if (getHandlingInfo().isSuccess()) {
            IFHandlingInfo handlingInfo = getHandlingInfo();
            Message message = messageContext.getCurrentMessage();
            Element body = getBodyElement(message);
            VerifyUtil.validateEnvelopedXSS4J(body, handlingInfo.getSignatureHandlingInfoBody());
         } else {
            logger.fatal(fn + "Didn't perform operation because HandlingInfo FAILED!");
         }
      } catch (Exception e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " <-- BODYSIGNATUREVALIDATOR");
      MDC.remove(OPTION_LOG_INFO);
   }
}
