package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler;

import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.axis.MessageContext;
import org.apache.axis.AxisFault;

/**
 * Class that decrypts the BODY-Section of incomming SOAP-Messages (if they are encrypted)
 */
public class BodyDecrypter extends BaseDecrypter{

   private static final Logger logger = Logger.getLogger(BodyDecrypter.class);

   /**
    * @see org.apache.axis.Handler#invoke(org.apache.axis.MessageContext)
    */
   public void invoke(MessageContext messageContext) throws AxisFault {
      String fn = "[invoke]";
      String logInfo = (String) getOption(OPTION_LOG_INFO);
      if(logInfo != null){
         MDC.put(OPTION_LOG_INFO, logInfo);
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " --> BODYDECRYPTER");
      super.invoke(messageContext);
      if(getHandlingInfo().isSuccess()){
         if (ENCRYPTION_ENABLED) {
            if (logger.isInfoEnabled()) logger.info(fn + "Encryption global ENABLED!");
         } else {
            if (logger.isInfoEnabled()) logger.info(fn + "Encryption global DISABLED!");
         }
      }
      if (logger.isDebugEnabled()) logger.debug(fn + " <-- BODYDECRYPTER!");
      MDC.remove(OPTION_LOG_INFO);
   }
}
