package de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler;

import org.apache.log4j.Logger;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.NS;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;

/**
 * Base-handler that may work with the differnt types of contexts.
 */
public abstract class BaseContextHandler extends BaseHandler{

   private static final Logger logger = Logger.getLogger(BaseContextHandler.class);

   /**
    * Gets the coordination-context-element out of the given document
    * @param doc The document the context shall be taken from.
    * @return
    */
   protected Element getCoordinationContextElement(Document doc){
      Element result = null;
      Element envelope = doc.getDocumentElement();
      NodeList contexts = envelope.getElementsByTagNameNS(NS.ACCESS_CONTROL_PROTOTYP_NAMESPACE, Constants.ELEMENT_NAME_COORDINATION_CONTEXT);
      result = (Element) contexts.item(0);
      return result;
   }

   /**
    * Gets the coordination-context-element out of the given document
    * @param msg The soap-message the context shall be taken from.
    * @return
    */
   protected Element getCoordinationContextElement(Message msg) throws Exception {
      Element result = null;
      SOAPEnvelope soapEnvelope = msg.getSOAPEnvelope();
      Document doc = soapEnvelope.getAsDocument();
      result = getCoordinationContextElement(doc);
      return result;
   }

   /**
    * Gets the step-context-element out of the given document
    * @param doc The document the context shall be taken from.
    * @return
    */
   protected Element getStepContextElement(Document doc){
      Element result = null;
      Element envelope = doc.getDocumentElement();
      NodeList contexts = envelope.getElementsByTagNameNS(NS.ACCESS_CONTROL_PROTOTYP_NAMESPACE, Constants.ELEMENT_NAME_STEP_CONTEXT);
      result = (Element) contexts.item(0);
      return result;
   }

   /**
    * Gets the step-context-element out of the given document
    * @param msg The soap-message the context shall be taken from.
    * @return
    */
   protected Element getStepContextElement(Message msg) throws Exception {
      Element result = null;
      SOAPEnvelope soapEnvelope = msg.getSOAPEnvelope();
      Document doc = soapEnvelope.getAsDocument();
      result = getStepContextElement(doc);
      return result;
   }

   /**
    * Gets the counting-context-element out of the given document
    * @param doc The document the context shall be taken from.
    * @return
    */
   protected Element getCountingContextElement(Document doc){
      Element result = null;
      Element envelope = doc.getDocumentElement();
      NodeList contexts = envelope.getElementsByTagNameNS(NS.ACCESS_CONTROL_PROTOTYP_NAMESPACE, Constants.ELEMENT_NAME_COUNTING_CONTEXT);
      result = (Element) contexts.item(0);
      return result;
   }

   /**
    * Gets the counting-context-element out of the given document
    * @param msg The soap-message the context shall be taken from.
    * @return
    */
   protected Element getCountingContextElement(Message msg) throws Exception {
      Element result = null;
      SOAPEnvelope soapEnvelope = msg.getSOAPEnvelope();
      Document doc = soapEnvelope.getAsDocument();
      result = getCountingContextElement(doc);
      return result;
   }
}
