package de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence;

/**
 * The base-interface for all evidence-mnagers (client, service and witness)
 */
public interface IFEvidenceManager {

   /**
    * Adds some evidence for a coordinationContext (several communications between the
    * client and several services)
    * @param evidence The evidence of the communication-context
    */
   public void addCoordinationContextEvidence(IFCoordinationContextEvidence evidence);

   /**
    * Removes some evidence for  coordination context.
    * @param evidence The evidence to remove.
    * @return In cas it existed the evidence, NULL else
    */
   public IFCoordinationContextEvidence removeCoordinationContextEvidence(IFCoordinationContextEvidence evidence);

   /**
    * Searches for a possibly existing Coordination-Context with the given ID.
    * @param coordinationContextId The ID to search for
    * @return The evidence if found, NULL else
    */
   public IFCoordinationContextEvidence getCoordinationContextEvidence(String coordinationContextId);

}
