package de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence;


/**
 * Interface that represents evidences that have been selected over the duration
 * of some communication (means all kind of data and linkings may be held)
 */
public interface IFCoordinationContextEvidence extends IFEvidence{

   /**
    * Gets the unique identifier of the surrounding context.
    * @return The contex identifier
    */
   public String getContextIdentification();

   /**
    * Adds a BodyEvidenc-Pair (Evidences that are together a concrete evidence -&gt; fe:
    * the signatures over the requests for some digestAgreementRequest from client and service)
    * @param bodyEvidencePair The pair that represents the evidence
    */
   public void addBodyEvidencePair(IFBodyEvidencePair bodyEvidencePair);

   /**
    * Removes some BodyEvidencePair from the managed list.
    * @param bodyEvidencePair The Evidence to remove.
    * @return The removed evidence in case it was foun, NULL else
    */
   public IFBodyEvidencePair removeBodyEvidencePair(IFBodyEvidencePair bodyEvidencePair);

   /**
    * Returns the list of currently managed evidences
    * @return The list
    */
   public IFBodyEvidencePair[] getBodyEvidencePairs();

   /**
    * Gets the BodyEvidence-Pair according to the given communication-nonce (identifier)
    * @param nonce The communication-identifier to search for.
    * @return The according evidence if found.
    */
   public IFBodyEvidencePair getBodyEvidencePair(String nonce);

}
