package de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;

/**
 * Class that represents an evidence for some coordinationContext.
 */
public class CoordinationContextEvidence implements IFCoordinationContextEvidence{

   private static final Logger logger = Logger.getLogger(CoordinationContextEvidence.class);

   private IFHandlingInfo handlingInfoToBeTakenFrom = null;

   public CoordinationContextEvidence(IFHandlingInfo handlingInfoToBeTakenFrom) {
      setHandlingInfo(handlingInfoToBeTakenFrom);
   }

   /**
    * @see IFCoordinationContextEvidence#addBodyEvidencePair(IFBodyEvidencePair)
    */
   public void addBodyEvidencePair(IFBodyEvidencePair bodyEvidencePair) {
   }

   /**
    * @see IFCoordinationContextEvidence#removeBodyEvidencePair(IFBodyEvidencePair)
    */
   public IFBodyEvidencePair removeBodyEvidencePair(IFBodyEvidencePair bodyEvidencePair) {
      IFBodyEvidencePair result = null;
      return result;
   }

   /**
    * @see IFCoordinationContextEvidence#getBodyEvidencePairs()
    */
   public IFBodyEvidencePair[] getBodyEvidencePairs() {
      IFBodyEvidencePair[] result = null;
      return result;
   }

   /**
    * @see IFCoordinationContextEvidence#getBodyEvidencePair(String)
    */
   public IFBodyEvidencePair getBodyEvidencePair(String nonce) {
      IFBodyEvidencePair result = null;
      return result;
   }

   /**
    * @see IFCoordinationContextEvidence#getContextIdentification()
    */
   public String getContextIdentification() {
      final String fn = "[getContextIdentification] ";
      String result = null;
      if(getHandlingInfo() != null && getHandlingInfo().getCountingContext() != null){
         result = getHandlingInfo().getCountingContext().getIdentification();
      }else{
         StringBuffer err = new StringBuffer("STATE-FAILURE: ");
         if(getHandlingInfo() == null){
            err.append("handlingInfo was NULL!");
         }else if(getHandlingInfo().getCountingContext() == null){
            err.append("countingContext was NULL!");
         }
         logger.error(fn + err);
      }
      return result;
   }

   /**
    * Gets the handlinginfo-object to this evidence.
    * @return
    */
   protected IFHandlingInfo getHandlingInfo() {
      return handlingInfoToBeTakenFrom;
   }

   /**
    * Sets the handlingInfo-object to this evidence
    * @param handlingInfoToBeTakenFrom
    */
   private void setHandlingInfo(IFHandlingInfo handlingInfoToBeTakenFrom) {
      this.handlingInfoToBeTakenFrom = handlingInfoToBeTakenFrom;
   }

   /**
    * @see IFCoordinationContextEvidence#isProofed() 
    */
   public boolean isProofed(){
      return true;
   }

}
