package de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence;

/**
 * Class that represents a pair of two BodyEvidence-Elements. This is used to
 * manage two BodyEvidences that are directly belonging to each other (f.e.
 * DigestAgreementRequests from client and service that adress the same message).
 */
public class BodyEvidencePair implements IFBodyEvidencePair{

   private static final Logger logger = Logger.getLogger(BodyEvidencePair.class);

   private IFBodyEvidence firstBodyEvidence = null;
   private IFBodyEvidence secondBodyEvidence = null;

   /**
    * @see IFBodyEvidencePair#getFirstBodyEvidence()
    */
   public IFBodyEvidence getFirstBodyEvidence() {
      return firstBodyEvidence;
   }

   /**
    * Sets the first body-evidence that is part of this pair.
    * @param firstBodyEvidence
    */
   public void setFirstBodyEvidence(IFBodyEvidence firstBodyEvidence) {
      this.firstBodyEvidence = firstBodyEvidence;
   }

   /**
    * @see IFBodyEvidencePair#getSecondBodyEvidence()
    */
   public IFBodyEvidence getSecondBodyEvidence() {
      return secondBodyEvidence;
   }

   /**
    * Sets the second body-evidence that is part of this pair.
    * @param secondBodyEvidence
    */
   public void setSecondBodyEvidence(IFBodyEvidence secondBodyEvidence) {
      this.secondBodyEvidence = secondBodyEvidence;
   }

}
