package de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence;

import org.apache.log4j.Logger;

import java.util.Map;
import java.util.HashMap;

/**
 * BaseEvidenceManager for instances of client, witness and service.
 */
public abstract class BaseEvidenceManager implements IFEvidenceManager{

   private static final Logger logger = Logger.getLogger(BaseEvidenceManager.class);

   private Map registeredCoordinationContextEvidences = null;

   public BaseEvidenceManager() {
      registeredCoordinationContextEvidences = new HashMap();
   }

   /**
    * @see IFEvidenceManager#addCoordinationContextEvidence(IFCoordinationContextEvidence)
    */
   public void addCoordinationContextEvidence(IFCoordinationContextEvidence evidence){
      final String fn = "[addCoordinationContextEvidence] ";
      if(evidence != null && evidence.isProofed()){
         if(registeredCoordinationContextEvidences.containsKey(evidence.getContextIdentification())){
            logger.warn(fn + "overwriting existing ");
         }
      }else{
         StringBuffer err = new StringBuffer("PARAM CHECK FAILED: ");
         if(evidence == null){
            err.append("evidence was NULL!");
         }else if(!evidence.isProofed()){
            err.append("evidence couldn't be proofed!");
         }
         logger.error(fn + err);
      }
   }

   /**
    * @see IFEvidenceManager#removeCoordinationContextEvidence(IFCoordinationContextEvidence)
    */
   public IFCoordinationContextEvidence removeCoordinationContextEvidence(IFCoordinationContextEvidence evidence){
      IFCoordinationContextEvidence result = null;

      return result;
   }

   /**
    * @see IFEvidenceManager#getCoordinationContextEvidence(String) 
    */
   public IFCoordinationContextEvidence getCoordinationContextEvidence(String coordinationContextId){
      IFCoordinationContextEvidence result = null;

      return result;
   }

}
