package de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

/**
 * Interface that represents some particular entity.
 */
public interface IFEntity {

   /**
    * Gets the internal int-representation of this entity.
    * @return
    */
   public int getId();

   /**
    * Gets the public key for validation of signatures generated by this entity.
    * @return The public key.
    */
   public Key getPublicSignatureKeyValue();

   /**
    * Gets the certificate of this entity.
    * @return The certificate.
    */
   public X509Certificate getSignatureCertificate();

}
