package de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.keystore.ApplicationSpecificKeystoreUtility;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.Entity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.entity.IFEntity;
import de.tu_dresden.diplom.richter_mirko_mat2628335.Configuration;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.UDDI;

/**
 * Pool that manages all entities that may be used within this prototype.
 */
public class EntityPool {

   private static final Logger logger = Logger.getLogger(EntityPool.class);

   private static final Configuration conf = new Configuration(Configuration.APPLICATION_BASE);

   private static IFEntity[] entities = null;

   static{
      int entityCount = ApplicationSpecificKeystoreUtility.SIG_ALIASES.length;
      boolean readFromUDDI = conf.isCertMethodUDDI();
      entities = new IFEntity[entityCount];
      for (int i = 0; i < entityCount; i++) {
         Entity newEntity = new Entity();
         if(readFromUDDI && ((i == ApplicationSpecificKeystoreUtility.ENTITY_TICKET_BOOKING) ||
              (i == ApplicationSpecificKeystoreUtility.ENTITY_TICKET_RESERVATION) ||
              (i == ApplicationSpecificKeystoreUtility.ENTITY_WITNESS_DIGESTER) ||
              (i == ApplicationSpecificKeystoreUtility.ENTITY_WITNESS_CONTEXT_REGISTRATOR))){
            UDDI uddi = new UDDI();
            if(i == ApplicationSpecificKeystoreUtility.ENTITY_TICKET_BOOKING){
               newEntity.setSignatureCertificate(uddi.getTicketBookingEntry().getLastCertificate());
            }else if(i == ApplicationSpecificKeystoreUtility.ENTITY_TICKET_RESERVATION){
               newEntity.setSignatureCertificate(uddi.getTicketReservationEntry().getLastCertificate());
            }else if(i == ApplicationSpecificKeystoreUtility.ENTITY_WITNESS_DIGESTER){
               newEntity.setSignatureCertificate(uddi.getWitnessDigesterEntry().getLastCertificate());
            }else if(i== ApplicationSpecificKeystoreUtility.ENTITY_WITNESS_CONTEXT_REGISTRATOR){
               newEntity.setSignatureCertificate(uddi.getWitnessContextRegistratorEntry().getLastCertificate());
            }
         }else{
            newEntity.setSignatureCertificate(ApplicationSpecificKeystoreUtility.getX509Certificate4Signature(i));
         }
         newEntity.setId(i);
         entities[i] = newEntity;
      }
   }

   /**
    * Gets the entity by its internal int-representation
    * @param entityID The internal id of the wanted entity.
    * @return
    */
   public static IFEntity getEntity(int entityID){
      return entities[entityID];
   }

   /**
    * Gets the entity by the name of the certificate (s short description tht is
    * transferred in the SOAP-Message as a hint for which certificate should be used)
    * @param certName The name of the certificate
    * @return The entity
    */
   public static IFEntity getEntityByCertName(String certName){
      final String fn = "[getEntityByCertName]";
      if (logger.isDebugEnabled()) logger.debug(fn + " looking for entity '" + certName + "'");
      int entityID = ApplicationSpecificKeystoreUtility.getEntityIDByKeyname(certName);
      if (logger.isDebugEnabled()) logger.debug(fn + " found entity in ApplicationSpecificKeystoreUtility at position '" + entityID + "'");
      return getEntity(entityID);
   }

   /**
    * Gets some entity by its alias.
    * @param alias The alias to look for.
    * @return The belonging entity.
    */
   public static IFEntity getEntityByAlias(String alias){
      final String fn = "[getEntityByAlias]";
      if (logger.isDebugEnabled()) logger.debug(fn + " looking for entity '" + alias + "'");
      int entityID = ApplicationSpecificKeystoreUtility.getEntityIDByAlias(alias);
      if (logger.isDebugEnabled()) logger.debug(fn + " found entity in ApplicationSpecificKeystoreUtility at position '" + entityID + "'");
      return getEntity(entityID);
   }
}
