package de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement;

/**
 * Interface for digest-agreement-responses that is being sent from witness
 * to client or service as answer for some agreement-request.
 */
public interface IFDigestAgreementResponse extends IFBaseDigestAgreementMsg{

   /**
    * Checks wheather the comparism at the witness was successfull or not.
    * @return
    */
   public boolean isSuccess();

   /**
    * String that references the made agreement in a request phase in the
    * response phase. (Notation: H1(Anfrage'))
    * @return
    */
   public String getAgreementReference();

   /**
    * Get the unique ID of the context that surrounds this operation
    * @return
    */
   public String getCoordinationCtxIdentification();

}
