package de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency.IFSOAPDependency;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAmount;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAmount;

/**
 * Interface for digest-agreement-requests that are being sent from client or service to witness.
 */
public interface IFDigestAgreementRequest extends IFBaseDigestAgreementMsg{

   /**
    * Gets the Nonce-value (being used to identify belonging digest-agreement-requests
    * at the witness)
    * @return The nonce-value
    */
   public String getNonce();

   /**
    * Gets the calculated digest from the request.
    * @return The digest
    */
   public String getDigest();

   /**
    * Gets the unique contextID whithin which this digest-agreement shall be performed.
    * @return
    */
   public String getContextID();

   /**
    * Gets the dependencies that shall be met.
    * @return The dependencies.
    */
   public IFSOAPDependency getDependency();

   /**
    * Gets the amount that is beeing added to the service account and is being removed
    * from the client account after operation has performed successfully.
    * @return
    */
   public IFAmount getAmount();

   /**
    * In the Request-phase the responder(server) must give the information
    * on which of his accounts the agreed amount shall be added.</br>
    * This identification specifies that account and is beeing ignored
    * if this is response-phase or the protocol-actor-role is Requester.
    * @return
    */
   public IFAccountIdentification getAccountIdentification();

   /**
    * Get the string that references a possible made agreement during a former communication step
    * that may reference a AcountTransferContext that is beeing executed in a response-phase.
    * @return
    */
   public String getAgreementReference();
}
