package de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement;

/**
 * The bas-interface for digest-agreement-requests and -responses.
 */
public interface IFBaseDigestAgreementMsg {

   /**
    * Indicates that this agreement request is sent with the digest
    * calculated over the request of some request.
    */
   public static final int PHASE_REQUEST = 0;

   /**
    * Indicates that this agreement request is sent with the digest
    * calculated over the response of some request.
    */
   public static final int PHASE_RESPONSE = 1;

   /**
    * Gest the Phase in that this digest-agreement is being performed.
    * @return one out of PHASE_REQUEST or PHASE_RESPONSE
    */
   public int getPhase();

   /**
    * Checks wheather this message has been sent in request-phase digest-agreement
    * @return true if request-phase, false else
    */
   public boolean isRequestPhase();

   /**
    * Checks wheather this message has been sent in reponse-phase digest-agreement
    * @return true if response-phase, false else
    */
   public boolean isResponsePhase();

}
