package de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement;

import org.apache.log4j.Logger;

/**
 * The default-implementation that represents a response that is being sent from the
 * witness to client or service in return to some digest-agreement-request
 */
public class DigestAgreementResponse extends BaseDigestAgreementMsg implements IFDigestAgreementResponse{

   private static final Logger logger = Logger.getLogger(DigestAgreementResponse.class);

   private boolean success = false;
   private String agreementReference = null;
   private String coordinationCtxIdentification = null;

   /**
    * @see IFDigestAgreementResponse#isSuccess()
    */
   public boolean isSuccess() {
      return success;
   }

   /**
    * Sets the success-state of this reponse-object
    * @param success
    */
   public void setSuccess(boolean success) {
      this.success = success;
   }

   /**
    * @see IFDigestAgreementResponse#getAgreementReference()
    */
   public String getAgreementReference() {
      return agreementReference;
   }

   /**
    * Sets the agreementReference
    * @param agreementReference
    */
   public void setAgreementReference(String agreementReference) {
      this.agreementReference = agreementReference;
   }

   /**
    * @see IFDigestAgreementResponse#getCoordinationCtxIdentification()
    */
   public String getCoordinationCtxIdentification() {
      return coordinationCtxIdentification;
   }

   /**
    * Sets the coordination-context-identification.
    * @param coordinationCtxIdentification
    */
   public void setCoordinationCtxIdentification(String coordinationCtxIdentification) {
      this.coordinationCtxIdentification = coordinationCtxIdentification;
   }

   /**
    * Generates a human-readable representation of this response-object.
    * @return
    */
   public String toString() {
      StringBuffer result = new StringBuffer("[DigestAgrementResponse::");
      if(isSuccess()){
         result.append(" success=true");
      }else{
         result.append(" success=false");
      }
      result.append(" | agreementReference=" + getAgreementReference());
      result.append("]");
      return result.toString();
   }

}
