package de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency.IFSOAPDependency;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAmount;

/**
 * Default-implementatzion that represents a dgest-agreement-request that is being sent
 * from client or service to the witness.
 */
public class DigestAgreementRequest extends BaseDigestAgreementMsg implements IFDigestAgreementRequest{

   private static final Logger logger = Logger.getLogger(DigestAgreementRequest.class);

   private String nonce = null;
   private String digest = null;
   private String contextID = null;
   private IFSOAPDependency dependency = null;
   private IFAccountIdentification accountIdentification = null;
   private long currentTs = 0;

   /**
    * String that is used to refernce a former made digest agreement
    * to find the belonging AccountTransferContext
    */
   private String agreementReference = null;

   private IFAmount amount = null;

   /**
    * Creates anew instance and sets the current timestamps to currentTimeMillis
    */
   public DigestAgreementRequest() {
      setCurrentTs(System.currentTimeMillis());
   }

   /**
    * @see IFDigestAgreementRequest#getNonce()
    */
   public String getNonce() {
      return nonce;
   }

   /**
    * Sets the nonce-value for this request.
    * @param nonce The new NONCE-value.
    */
   public void setNonce(String nonce) {
      this.nonce = nonce;
      //@TODO in this prototype the nonce-value in the response-phase-digestAgreement equals to the agreement-refernce 
      setAgreementReference(nonce);
   }

   /**
    * @see IFDigestAgreementRequest#getDigest()
    */
   public String getDigest() {
      return digest;
   }

   /**
    * Sets the digest of the corresponding message.
    * @param digest The new digest
    */
   public void setDigest(String digest) {
      this.digest = digest;
   }

   /**
    * @see IFDigestAgreementRequest#getContextID()
    */
   public String getContextID() {
      return contextID;
   }

   /**
    * Sets the contextID that is being used to identify the surrounding
    * context.
    * @param contextID The identifier of the context.
    */
   public void setContextID(String contextID) {
      this.contextID = contextID;
   }

   /**
    * @see IFDigestAgreementRequest#getDependency()
    */
   public IFSOAPDependency getDependency() {
      return dependency;
   }

   /**
    * Sets the dependencies.
    * @param dependency The dependencies
    */
   public void setDependency(IFSOAPDependency dependency) {
      this.dependency = dependency;
   }

   /**
    * @see IFDigestAgreementRequest#getAmount()
    */
   public IFAmount getAmount() {
      return amount;
   }

   /**
    * Sets the amount that is beeing subtracted from the clients account and added to
    * the service's account
    * @param amount The fee for the operation
    */
   public void setAmount(IFAmount amount) {
      this.amount = amount;
   }

   /**
    * @see IFDigestAgreementRequest#getAccountIdentification()
    */
   public IFAccountIdentification getAccountIdentification() {
      return accountIdentification;
   }

   /**
    * Sets the account-identification
    * @param accountIdentification The new account-identification
    */
   public void setAccountIdentification(IFAccountIdentification accountIdentification) {
      this.accountIdentification = accountIdentification;
   }

   /**
    * @see IFDigestAgreementRequest#getAgreementReference()
    */
   public String getAgreementReference() {
      return agreementReference;
   }

   /**
    * Sets the reference that is trying to be agreed on.
    * @param agreementReference
    */
   public void setAgreementReference(String agreementReference) {
      this.agreementReference = agreementReference;
   }

   /**
    * Gets the current timestamp in ms (the moment as the request was generated).
    * @return
    */
   public long getCurrentTs() {
      return currentTs;
   }

   /**
    * Sets the current timestamp.
    * @param currentTs
    */
   public void setCurrentTs(long currentTs) {
      this.currentTs = currentTs;
   }

   /**
    * Creates a human-readable string-representation of this object.
    * @return
    */
   public String toString() {
      StringBuffer result = new StringBuffer("[DigestAgreementRequest:: ");
      result.append(" nonce=").append(getNonce());
      result.append(" | digest=").append(getDigest());
      result.append(" | contextID=").append(getContextID());
      result.append(" | dependency=").append(getDependency());
      result.append("]");
      return result.toString();
   }
}
