package de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement;

import org.apache.log4j.Logger;

/**
 * Default-Implementation of the basic functionality that is
 * common to digest-agreement-request and -response
 */
public abstract class BaseDigestAgreementMsg implements IFBaseDigestAgreementMsg{

   private static final Logger logger = Logger.getLogger(BaseDigestAgreementMsg.class);

   private int phase = PHASE_REQUEST;

   /**
    * @see IFBaseDigestAgreementMsg#getPhase()
    */
   public int getPhase() {
      return phase;
   }

   /**
    * Sets the phase of this operation.
    * @param phase The current phase.
    */
   public void setPhase(int phase) {
      this.phase = phase;
   }

   /**
    * @see IFBaseDigestAgreementMsg#isRequestPhase()
    */
   public boolean isRequestPhase(){
      return getPhase()==PHASE_REQUEST;
   }

   /**
    * Sets current phase to be the request-phase
    */
   public void setRequestPhase(){
      setPhase(PHASE_REQUEST);
   }

   /**
    * @see IFBaseDigestAgreementMsg#isResponsePhase() 
    */
   public boolean isResponsePhase(){
      return getPhase()==PHASE_RESPONSE;
   }

   /**
    * Sets current phase to be the response-phase
    */
   public void setResponsePhase(){
      setPhase(PHASE_RESPONSE);
   }
}
