package de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency;

import org.apache.log4j.Logger;

/**
 * Default-implementation of a SOAP-dependency-statement that is being placed in the SOAP-header within the
 * step-context-element.
 */
public class SOAPDependencyStatement implements IFSOAPDependencyStatement{

   private static final Logger logger = Logger.getLogger(SOAPDependencyStatement.class);

   private String dependency = null;

   /**
    * Creates a new dependency out of the given string (in prototype a hash of a former agreed message)
    * @param dependency The dependency.
    */
   public SOAPDependencyStatement(String dependency) {
      this.dependency = dependency;
   }

   /**
    * Creates a empty object
    */
   public SOAPDependencyStatement() {
   }

   /**
    * @see IFSOAPDependencyStatement#getDependency()
    */
   public String getDependency() {
      return dependency;
   }

   /**
    * Sets the given dependency-string
    * @param dependency The new dependency.
    */
   public void setDependency(String dependency) {
      this.dependency = dependency;
   }

   /**
    * generates a human-readable version of this instance.
    * @return
    */
   public String toString() {
      StringBuffer result = new StringBuffer("[SOAPDependencyStatement::");
      result.append(" dependency=").append(getDependency());
      result.append("]");
      return result.toString();
   }

}
