package de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.util.ToStringUtil;

/**
 * The default-implementation of a SOAP-Dependency that is being placed into
 * the header of some SOAP-message (within Step-context)
 */
public class SOAPDependency implements IFSOAPDependency {

   private static final Logger logger = Logger.getLogger(SOAPDependency.class);

   private IFSOAPDependencyStatement[] dependencyStatements = null;

   /**
    * @see IFSOAPDependency#getDependencyStatements()
    */
   public IFSOAPDependencyStatement[] getDependencyStatements() {
      return dependencyStatements;
   }

   /**
    * Sets the list of concrete dependencies (digests in prototype).
    * @param dependencyStatements The new concrete dependencies
    */
   public void setDependencyStatements(IFSOAPDependencyStatement[] dependencyStatements) {
      this.dependencyStatements = dependencyStatements;
   }

   /**
    * Adds one dependency to the list of already existing dependencies.
    * @param stmnt The new statement.
    */
   public void addDependencyStatement(IFSOAPDependencyStatement stmnt) {
      final String fn = "[addDependencyStatement] ";
      if (stmnt != null) {
         if (getDependencyStatements() == null) {
            setDependencyStatements(new IFSOAPDependencyStatement[]{stmnt});
         }else{
            IFSOAPDependencyStatement[] newStatements = new IFSOAPDependencyStatement[getDependencyStatements().length + 1];
            System.arraycopy(getDependencyStatements(), 0, newStatements, 0, getDependencyStatements().length);
            newStatements[getDependencyStatements().length] = stmnt;
            setDependencyStatements(newStatements);
         }
      }else{
         logger.warn(fn + "NULL PARAM IS NOT ALLOWED!");
      }
   }

   /**
    * Generates a human-readable version of this object.
    * @return
    */
   public String toString() {
      StringBuffer result = new StringBuffer("SOAPDependency");
      if (dependencyStatements != null) {
         result.append(" dependencyStatements=Array[");
         for (int i = 0; i < dependencyStatements.length; i++) {
            IFSOAPDependencyStatement dependencyStatement = dependencyStatements[i];
            result.append(dependencyStatement);
         }
      } else {
         result.append(" dependencyStatements=NULL");
      }
      result.append("]]");
      return result.toString();
   }

}
