package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.AccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFBaseContext;

/**
 * The interface of some reuqest for context creation (client->witness)
 */
public interface IFContextCreationRequest extends IFBaseContext{

   /**
    * Gets the nonce-value (communication-identification). Used to prevent
    * from replay-attacks
    * @return the nonce-value
    */
   public String getNonce();

   /**
    * Gets the timeout that has been set for the request phase (step 1 und 2 in written
    * part). If one of (2a) or (2b) is missing and this timeout has run out, a callback-message
    * is being sent to the service.
    * @return the timeout
    */
   public long getTimeoutMSRequest();

   /**
    * Gets the timeout that has been set for the request phase (step 4 und 5 in written
    * part). If one of (5a) or (5b) is missing and this timeout has run out, a callback-message
    * is being sent to the service.
    * @return the timeout
    */
   public long getTimeoutMSResponse();

   /**
    * Gets the lifetime of the context to be created (in millis). After this time has gone
    * beginning at the witness' creationtime the context is being automatically invalidated
    * at the witness.
    * @return the lifetime in millis.
    */
   public long getLifeTimeMS();

   /**
    * Gets the accountID to identify the account of the client.
    * @return the account-id
    */
   public IFAccountIdentification getAccountIdentification();

   /**
    * Gets the currentTs which has been set by the client as he sent this request.
    * @return the time in millis (since 1980)
    */
   public long getCurrentTs();
}
