package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm;

import org.apache.log4j.Logger;

/**
 * Reqeust that is being transmitted from client to witness to indicate that some
 * context should be removed/invalidated.
 */
public class ContextRemovalRequest implements IFContextRemovalRequest{

   private static final Logger logger = Logger.getLogger(ContextRemovalRequest.class);

   private long currentTs = 0;

   /**
    * Creates new instance with the currentTimeMillis as currentTs.
    */
   public ContextRemovalRequest() {
      setCurrentTs(System.currentTimeMillis());
   }

   /**
    * @see IFContextRemovalRequest#getCurrentTs()
    */
   public long getCurrentTs() {
      return currentTs;
   }

   /**
    * Sets the current Timestamp
    * @param currentTs current timestamp in millis
    */
   public void setCurrentTs(long currentTs) {
      this.currentTs = currentTs;
   }
}
